/** 			savecopy.c			**/

/** Save a copy of the specified message in the users savemail mailbox.

         (C) Copyright 1986, Dave Taylor 			       
**/

#include "headers.h"
#ifdef BSD
#  include <sys/time.h>
#else
#  include <time.h>
#endif

char *format_long(), *get_arpa_date();

extern char reply_to[SLEN];	/* In-Reply-To: string */
extern int gotten_key;		/* for encryption      */

save_copy(subject, to, cc, filename, original_to)
char *subject, *to, *cc, *filename, *original_to;
{
	/** This routine appends a copy of the outgoing message to the
	    file specified by the SAVEFILE environment variable.  **/

	FILE *save,		/* file id for file to save to */
	     *message;		/* the actual message body     */
	long  thetime;		/* variable holder for time    */
	char  buffer[SLEN],	/* read buffer 		       */
	      savename[SLEN],	/* name of file saving into    */
	      newbuffer[SLEN];  /* first name in 'to' line     */
	register int i;		/* for chopping 'to' line up   */
	int   crypted=0;	/* are we encrypting?          */

	dprint5(
"save_copy(subject='%s', to='%s', cc='%s', filename='%s', original-to='%s')\n", 
		 subject, to, cc, filename, original_to);

	savename[0] = '\0';

	if (save_by_name) {
	  get_return_name(to, buffer);
	  sprintf(savename, "%s%s%s", folders, 
	          lastch(folders) == '/'? "" : "/", buffer);
	  if (access(savename, ACCESS_EXISTS) == -1) 	/* don't create new! */
	    savename[0] = '\0';
	}

	if (strlen(savename) == 0) {
	  if (strlen(savefile) == 0)
	    return(error("variable 'SAVEFILE' not defined!"));
	  strcpy(savename, savefile);
	  if (save_by_name)
	    error2("Not creating file '%s'...saving in %s instead",
	  	   buffer, savename);
	}

	dprint1("\tsaving copy of outbound message to file '%s'\n", savename);

	if ((save = fopen(savename, "a")) == NULL)
	  return(error1("couldn't append to %s", savename));

	if ((message = fopen(filename, "r")) == NULL) {
	  fclose(save);
	  return(error1("save_copy couldn't read file %s!", filename));
	}

	for (i=0; original_to[i] != '\0' && ! whitespace(original_to[i]); i++)
	  newbuffer[i] = original_to[i];

	newbuffer[i] = '\0';

	tail_of(newbuffer, buffer, FALSE);

	thetime = time(0);	/* this must be here for it to work! */

	fprintf(save,"\nFrom To:%s %s", buffer, (char *) ctime(&thetime));

	fprintf(save, "Date: %s\n", get_arpa_date());
			
	fprintf(save,"To: %s\nSubject: %s\n", 
		format_long(to,strlen("To: ")), subject);

	if (strlen(cc) > 0)
	  fprintf(save,"Cc: %s\n", 
		  format_long(cc, strlen("Cc:")));

	if (strlen(reply_to) > 0)
	  fprintf(save, "In-Reply-To: %s\n", reply_to);

	(void) putc('\n', save);	/* put another return, please! */

	/** now copy over the message... **/

	while (fgets(buffer, SLEN, message) != NULL) {
	  if (buffer[0] == '[') {
	    if (strncmp(buffer, START_ENCODE, strlen(START_ENCODE))==0)
	      crypted = 1;
	    else if (strncmp(buffer, END_ENCODE, strlen(END_ENCODE))==0)
	      crypted = 0;
	    else if (strncmp(buffer, DONT_SAVE, strlen(DONT_SAVE)) == 0) {
	      fclose(message);
	      fclose(save);
	      chown(savename, userid, getgid());	
	      return(TRUE);
	    }
	  }
	  else if (crypted) {
	    if (! gotten_key++)
	      getkey(ON);
	    encode(buffer);
	  }
	  fputs(buffer, save);
	}

	dprint0("\tclosing the files...\n");

	fclose(message);
	fclose(save);

	/* make sure save file isn't owned by root! */
	chown(savename, userid, getgid());	

	return(TRUE);
}
