/**		reply.c		**/

/*** routine allows replying to the sender of the current message 

     (C) Copyright 1985, Dave Taylor
***/

#include "headers.h"
#ifndef BSD
#  include <sys/utsname.h>
#endif

/** Note that this routine generates automatic header information
    for the subject and (obviously) to lines, but that these can
    be altered while in the editor composing the reply message! 
**/

char *strip_parens(), *get_token(), *notes_machine();

int
reply()
{
	/** Reply to the current message.  Returns non-zero iff
	    the screen has to be rewritten. **/

	char return_address[LONG_SLEN], subject[SLEN];
	int  return_value;

	dprint0("reply()\n");

	get_return(return_address);
	
	if (header_table[current-1].subject[0] != '\0') {
	  if ((strncmp("Re:", header_table[current-1].subject, 3) == 0) ||
	      (strncmp("RE:", header_table[current-1].subject, 3) == 0) ||
	      (strncmp("re:", header_table[current-1].subject, 3) == 0)) 
	    strcpy(subject, header_table[current-1].subject);
	  else {
	    strcpy(subject,"Re: ");
	    strcat(subject,header_table[current-1].subject); 
	  }
	  return_value = send(return_address, subject, TRUE);
	}
	else
	  return_value = send(return_address, "Re: your mail", TRUE);

	return(return_value);
}

int
reply_to_everyone()
{
	/** Reply to everyone who received the current message.  
	    This includes other people in the 'To:' line and people
	    in the 'Cc:' line too.  Returns non-zero iff the screen 
            has to be rewritten. **/

	char return_address[LONG_SLEN], subject[SLEN];
	char full_address[VERY_LONG_STRING];
	int  return_value;

	dprint0("reply_to_everyone()\n");

	get_return(return_address);

	strcpy(full_address, return_address);	/* sender gets copy */
	
	get_and_expand_everyone(return_address, full_address);

	if (header_table[current-1].subject[0] != '\0') {
	  if ((strncmp("Re:", header_table[current-1].subject, 3) == 0) ||
	      (strncmp("RE:", header_table[current-1].subject, 3) == 0) ||
	      (strncmp("re:", header_table[current-1].subject, 3) == 0)) 
	    strcpy(subject, header_table[current-1].subject);
	  else {
	    strcpy(subject,"Re: ");
	    strcat(subject,header_table[current-1].subject); 
	  }
	  return_value = send(full_address, subject, TRUE);
	}
	else
	  return_value = send(full_address, "Re: your mail", TRUE);

	return(return_value);

}

int
forward()
{
	/** Forward the current message.  What this actually does is
	    to set auto_copy to true, then call 'send' to get the 
	    address and route the mail. 
	**/

	char subject[SLEN], address[VERY_LONG_STRING];
	int  original_cc, results, edit_msg;

	dprint0("forward()\n");

	original_cc = auto_copy;
	address[0] = '\0';

	edit_msg = (want_to("Edit outgoing message (y/n) ? ",'y',FALSE) != 'n');
	printf("%s", edit_msg? "Yes" : "No");

	auto_cc = TRUE;			/* we want a copy */

	if (strlen(header_table[current-1].subject) > 0) {
	  strcpy(subject,header_table[current-1].subject); 
	  results = send(address, subject, edit_msg);
	}
	else
	  results = send(address, "Forwarded Mail...", edit_msg);
	
	auto_copy = original_cc;

	return(results);
}

get_and_expand_everyone(return_address, full_address)
char *return_address, *full_address;
{
	/** Read the current message, extracting addresses from the 'To:'
	    and 'Cc:' lines.   As each address is taken, ensure that it
	    isn't to the author of the message NOR to us.  If neither,
	    prepend with current return address and append to the 
	    'full_address' string.
	**/

    char ret_address[LONG_SLEN], buf[LONG_SLEN], new_address[LONG_SLEN];
    char *bufptr, *address;
    int  in_message = 1, first_pass = 0;

    dprint1("get_and_expand_everyone(return_address='%s', <buffer>)\n", 
	     return_address);

    /** First off, get to the first line of the message desired **/

    if (fseek(mailfile, header_table[current-1].offset, 0) == -1) {
	error1("msg [seek] couldn't read %d bytes into file",
	       header_table[current-1].offset);
	return;
    }
 
    /** okay!  Now we're there!  **/

    /** let's fix the ret_address to reflect the return address of this
	message with '%s' instead of the persons login name... **/

    translate_return(return_address, ret_address);

    /** now let's parse the actual message! **/

    while (in_message) {
      in_message = (int) (fgets(buf, LONG_SLEN, mailfile) != NULL);
      if (first_word(buf, "From ") && first_pass++ != 0) 
	in_message = FALSE;
      else if (first_word(buf, "To:") || first_word(buf, "Cc:") ||
	       first_word(buf, "CC:") || first_word(buf, "cc:")) {
	do {
	  no_ret(buf);

	  bufptr = (char *) (strip_parens(buf) + 3); /* 3 = strlen of prompt */

	  while ((address = get_token(bufptr, "\t, ", 0)) != NULL) {
	    if (okay_address(address, return_address)) {
	      sprintf(new_address, ret_address, address);
	      optimize_and_add(new_address, full_address);
	    }
	    bufptr = NULL;
	  }

          in_message = (int) (fgets(buf, LONG_SLEN, mailfile) != NULL);
	
	} while (in_message && whitespace(buf[0]));

      }
      else if (strlen(buf) < 2)	/* done with header */
	 in_message = FALSE;
    }
}

int
okay_address(address, return_address)
char *address, *return_address;
{
	/** This routine checks to ensure that the address we just got
	    from the "To:" or "Cc:" line isn't us AND isn't the person	
	    who sent the message.  Returns true iff neither is the case **/

	char our_address[SLEN];
	struct addr_rec  *alternatives;

	if (in_string(address, return_address))
	  return(FALSE);

	sprintf(our_address, "%s!%s", hostname, username);

	if (in_string(address, our_address))
	  return(FALSE);

	sprintf(our_address, "%s@%s", username, hostname);
	  
	if (in_string(address, our_address))
	  return(FALSE);

	alternatives = alternative_addresses;

	while (alternatives != NULL) {
	  if (in_string(address, alternatives->address))
	    return(FALSE);
	  alternatives = alternatives->next;
	}

	return(TRUE);
}
	    
optimize_and_add(new_address, full_address)
char *new_address, *full_address;
{
	/** This routine will add the new address to the list of addresses
	    in the full address buffer IFF it doesn't already occur.  It
	    will also try to fix dumb hops if possible, specifically hops
	    of the form ...a!b...!a... and hops of the form a@b@b etc 
	**/

	register int len, host_count = 0, i;
	char     hosts[MAX_HOPS][SLEN];	/* array of machine names */
	char     *host, *addrptr;

	if (in_string(full_address, new_address))
	  return(1);	/* duplicate address */

	/** optimize **/
	/*  break down into a list of machine names, checking as we go along */
	
	addrptr = (char *) new_address;

	while ((host = get_token(addrptr, "!", 1)) != NULL) {
	  for (i = 0; i < host_count && ! equal(hosts[i], host); i++)
	      ;

	  if (i == host_count) {
	    strcpy(hosts[host_count++], host);
	    if (host_count == MAX_HOPS) {
	       error("Can't build return address - hit MAX_HOPS limit!");
	       return(1);
	    }
	  }
	  else 
	    host_count = i + 1;
	  addrptr = NULL;
	}

	/** fix the ARPA addresses, if needed **/
	
	if (chloc(hosts[host_count-1], '@') > -1)
	  fix_arpa_address(hosts[host_count-1]);
	  
	/** rebuild the address.. **/

	new_address[0] = '\0';

	for (i = 0; i < host_count; i++)
	  sprintf(new_address, "%s%s%s", new_address, 
	          new_address[0] == '\0'? "" : "!",
	          hosts[i]);

	dprint1("\tgenerated address '%s'\n", new_address);

	if (full_address[0] == '\0')
	  strcpy(full_address, new_address);
	else {
	  len = strlen(full_address);
	  full_address[len  ] = ',';
	  full_address[len+1] = ' ';
	  full_address[len+2] = '\0';
	  strcat(full_address, new_address);
	}

	return(0);
}

get_return_name(address, name)
char *address, *name;
{
	/** Given the address (either a single address or a combined list 
	    of addresses) extract the login name of the first person on
	    the list and return it as 'name'.  Modified to stop at
	    any non-alphanumeric character. **/

	/** An important note to remember is that it isn't vital that this
	    always returns just the login name, but rather that it always
	    returns the SAME name.  If the persons' login happens to be,
	    for example, joe.richards, then it's arguable if the name 
	    should be joe, or the full login.  It's really immaterial, as
	    indicated before, so long as we ALWAYS return the same name! **/

	/** Another note: modified to return the argument as all lowercase
	    always... **/

	char single_address[LONG_SLEN];
	register int i, loc, index = 0;

	/* first step - copy address up to a comma, space, or EOLN */

	for (i=0; address[i] != ',' && ! whitespace(address[i]) && 
	     address[i] != '\0'; i++)
	  single_address[i] = address[i];
	single_address[i] = '\0';

	/* Now is it an ARPA address?? */

	if ((loc = chloc(single_address, '@')) != -1) {	  /* Yes */

	  /* At this point the algorithm is to keep shifting our copy 
	     window left until we hit a '!'.  The login name is then
             located between the '!' and the first metacharacter to 
	     it's right (ie '%', ':' or '@'). */

	  for (i=loc; single_address[i] != '!' && i > -1; i--)
	      if (single_address[i] == '%' || 
	          single_address[i] == ':' ||
	          single_address[i] == '.' ||	/* no domains */
		  single_address[i] == '@') loc = i-1;
	
	  if (single_address[i] == '!') i++;

	  for (index = 0; index < loc - i + 1; index++)
	    name[index] = tolower(single_address[index+i]);
	  name[index] = '\0';
	}
	else {	/* easier - standard USENET address */

	  /* This really is easier - we just cruise left from the end of
	     the string until we hit either a '!' or the beginning of the
             line.  No sweat. */

	  loc = strlen(single_address)-1; 	/* last char */

	  for (i = loc; single_address[i] != '!' && single_address[i] != '.' 
	       && i > -1; i--)
	     name[index++] = tolower(single_address[i]);
	  name[index] = '\0';
	  reverse(name);
	}
}
