/**			mkhdrs.c		**/

/** This contains all the header generating routines for the MSG
    program.

    (C) Copyright 1985 Dave Taylor

**/

#include <stdio.h>
#include "headers.h"

extern char reply_to[SLEN];

generate_reply_to(msg)
int msg;
{
	/** Generate an 'in-reply-to' message... **/
	char buffer[SLEN];


	if (msg == -1)		/* not a reply! */
	  reply_to[0] = '\0';
	else {
	  if (chloc(header_table[msg].from, '!') != -1)
	    tail_of(header_table[msg].from, buffer, FALSE);
	  else
	    strcpy(buffer, header_table[msg].from);
	  sprintf(reply_to, "Message from \"%s\" of %s %s, %s at %s",
		  buffer,
		  header_table[msg].month,
		  header_table[msg].day,
		  header_table[msg].year,
		  header_table[msg].time);
	}
}
