/** 			mailout.c			**/

/** Interface to allow mail to be sent to users.  Part of MSG  **/

/** (C) Copyright 1986, Dave Taylor 			       **/

/** System output is a line of the form;

	sendmail -oi addresses < tempfile
    or
	mailer addresses < tempfile

    Changed 8/12 to conform to RFC-822 style headers (ARPA and so on)
    Changed 9/23 to deal with commas, and other bug fixes
    Changed 9/24 to add reading the users .mailheaders file
    Changed 10/26 to use the shared subject, to, cc, etc fields
    Changed 2/20 to use batch_subject, if specified 
**/

#include "headers.h"

/** strings defined for the hdrconfg routines **/

char subject[SLEN], action[SLEN], reply_to[SLEN], expires[SLEN], priority[SLEN];
char to[VERY_LONG_STRING], cc[VERY_LONG_STRING];

char *format_long(), *strip_commas(), *tail_of_string();

int gotten_key = 0;

int
send(given_to, given_subject, edit_message)
char *given_to, *given_subject;
int   edit_message;
{
	/** Prompt for fields and then call mail() to send the specified
	    message.  If 'edit_message' is true then don't allow the
            message to be edited. **/

	char address[VERY_LONG_STRING];  /* BIG address! */
	char addressII[VERY_LONG_STRING];
	char *buffer;			/* misc, for I/O */

	int  copy_msg = FALSE, is_a_response = FALSE;

	dprint2("send(to='%s', subject='%s')\n", given_to, given_subject);

	/* zero all current global message strings */

	cc[0] = action[0] = reply_to[0] = expires[0] = priority[0] = '\0';

	addressII[0] = '\0';

	/* initialize 'to' and 'subject' according to what we were given */

	strcpy(subject, given_subject);
	strcpy(to, given_to);

	/** Copy message? **/

	if (strlen(to) > 0 && !mail_only) {	/* predefined 'to' line! */
	  if (auto_copy) 
	    copy_msg = TRUE;
	  else 
	    copy_msg = (want_to("Copy message? (y/n) ", 'n', TRUE) == 'y');
	  is_a_response = TRUE;
	}
	else
	  if (strlen(subject) > 0)  	/* predefined 'subject' (Forward) */
	    copy_msg = TRUE;

	/**  To:  **/
 
	if (strlen(to) == 0) {
	  PutLine(LINES-2, 0, "To: ");
	  (void) optionally_enter(to, LINES-2, 4, FALSE); 
	  if (strlen(to) == 0) {
	    MoveCursor(LINES-2,0);	CleartoEOLN();
	    error("mail not sent");
	    return(0);
	  }
	  build_address(strip_commas(to), address); 
	}
	else if (mail_only) 
	  build_address(strip_commas(to), address); 
	else 
	  strcpy(address, to);
	
	if (strlen(address) == 0) {	/* bad address!  Removed!! */
	  if (! mail_only)
	    ClearLine(LINES-2);
	  return(0);
	}

	if (! mail_only) {
	  MoveCursor(LINES-3, COLUMNS-50);
	  CleartoEOLN();
	  printf("          "); 	/* 10 spaces */
	}

	if (mail_only && strlen(batch_subject) > 0) {

	  /** User wants to send the mail without editing or anything...
	      just suck in stdin for the file and don't prompt for anything! 
	  **/

	  strcpy(subject, batch_subject);

	  mail(address, NULL, FALSE, FALSE, FALSE, TRUE);
	
	  return;
	}

	if (mail_only && check_only) {
	  printf("Expands to: %s\n", format_long(address, 12));
	  leave();
	}

	if (mail_only)
	  printf("To: %s\n\r", format_long(address));
	else {
	  if (strlen(address) > COLUMNS-50) {
	    buffer = tail_of_string(address, COLUMNS-50);
	    printf("To: (%s)", buffer);
	  }
	  else
	    printf("To: %s", address);
	}
  
	/** Subject: **/

	if (mail_only)
	  printf("Subject: ");
	else 
	  PutLine(LINES-2,0,"Subject: ");
	CleartoEOLN();
	if (optionally_enter(subject, LINES-2, 9, TRUE) == -1) {
	  MoveCursor(LINES-2,0); 	CleartoEOLN();
	  error("mail not sent");
	  return(0);
	}

	if (strlen(subject) == 0) {
	  if (mail_only) 
	    printf("\n\rNo subject - Continue with message? (y/n) ");
	  else
	    PutLine(LINES-2,0,"No subject - Continue with message? (y/n) ");
	  printf("n%c", BACKSPACE);
	  fflush(stdout);
	  if (tolower(ReadCh()) != 'y') {
	    if (mail_only) {
	      printf("\n\r\n\rMail Cancelled!\n\r");
	      return(0);
	    }
	    MoveCursor(LINES-2,0);	CleartoEOLN();
	    error("mail not sent");
	    return(0);
	  }
	  else if (! mail_only) {
	    PutLine(LINES-2,0,"Subject: <none>");
	    CleartoEOLN();
	  }
	}

	/** Copies to: **/

	if (mail_only)
	  printf("\n\rCopies To: ");
	else
	  PutLine(LINES-1,0,"Copies To: ");

	fflush(stdout);

	if (optionally_enter(cc, LINES-1, 11, FALSE) == -1) {
	  if (mail_only) {
	    printf("\n\r\n\rMail not sent!\n\r");
	    return(0);
	  }
	  MoveCursor(LINES-2,0); 	CleartoEOLN();
	  MoveCursor(LINES-1,0); 	CleartoEOLN();
	  error("mail not sent");
	  return(0);
	}
	  
	build_address(strip_commas(cc), addressII);

	if (strlen(address) + strlen(addressII) > VERY_LONG_STRING) {
	  error("Too many people.  Copies ignored");
	  cc[0] = '\0';
	}
	
	if (mail_only) 
	  printf("\n\r");
	else
	  MoveCursor(LINES,0);	/* you know you're hit <return> ! */

	/* and mail that puppy outta here! */

	mail(address, addressII, copy_msg, is_a_response, edit_message, FALSE);
	
	return(edit_message);
}

mail(expanded_to, expanded_cc, copy_msg, is_a_response, edit_message, batch)
char *expanded_to, *expanded_cc;
int  copy_msg, is_a_response, edit_message, batch;
{
	/** Given the addresses and various other miscellany (specifically, 
	    'copy-msg' indicates whether a copy of the current message should 
	    be included, 'is-a-response' indicates if 'In-Reply-To:' should be 
	    generated for this message, 'edit_message' indicates whether the
	    message should be edited and 'batch' indicates that the message
	    should be read from stdin) this routine will invoke an editor for
	    the user and then actually mail off the message.
	**/

	FILE *reply, *real_reply; /* second is post-input buffer */
	FILE *headerfile;	  /* copy default headers        */
	char buffer[LONG_SLEN], filename[SLEN], filename2[SLEN],
             very_long_buffer[VERY_LONG_STRING];
	char hfname[SLEN], ret_ch;
	register int i, crypted=0, encoded_lines = 0, retransmit = 0;

	static int cancelled_msg = 0;
	
	dprint6("mail(to='%s', cc='%s', copy-msg=%s, is-a-response=%s, edit-message=%s, batch=%s)\n", 
	         expanded_to, expanded_cc, onoff(copy_msg), 
	         onoff(is_a_response), onoff(edit_message), onoff(batch));

	sprintf(filename,"%s%d",temp_file, getpid());

	if (! batch) {
	  if ((reply = fopen(filename,"r")) != NULL && cancelled_msg) {
	    Raw(ON);
	    if (copy_msg)
	      PutLine(LINES-1,0,"Recall last kept message instead? (y/n) ");
	    else
	      PutLine(LINES-1,0,"Recall last kept message? (y/n) ");
	    CleartoEOS();
	    printf("y%c", BACKSPACE);
	    fflush(stdout);
	    if (tolower(ReadCh()) != 'n') {
	      printf("Yes");	fflush(stdout);
              retransmit++;
	    }
	    else {
	      printf("No");	fflush(stdout);
              fclose(reply);
	    }
	    cancelled_msg = 0;
	  }
	}

	if (! retransmit)
	  if ((reply = fopen(filename,"w")) == NULL)
	    return(error1("Could not create file %s",filename));

	if (copy_msg) 
	  if (edit_message) 
	    copy_message(prefixchars, reply, noheader);
	  else
	    copy_message("", reply, noheader);
	
	if (batch) {
	  Raw(OFF);
	  ret_ch = '\n';
	  if (isatty(fileno(stdin))) {
	    printf("To: %s\nSubject: %s\n", expanded_to, subject);
	    printf("\nPlease enter your message, ending with a ^D:\n\n");
	    ret_ch = '\0';
	  }
	  while (gets(very_long_buffer, VERY_LONG_STRING) != NULL) 
	    fprintf(reply, "%s%c", very_long_buffer, ret_ch);

	  if (isatty(fileno(stdin))) 
	    printf("\n<end-of-message>\n");
	}

	fclose(reply);

	if (edit_message) {
	  sprintf(buffer,"%s %s", editor, filename);

	  Raw(OFF);
	  chown(filename, userid, getgid());
	  if ((i =system_call(buffer,SH)) != 0)	{ 	/* edit mail as user */
	    error1("Problems with the editor: error %d", i);
	    MoveCursor(LINES-1,0); CleartoEOLN();
	    sleep(2);
	  }
	
	  Raw(ON);
	}

	if ((reply = fopen(filename,"r")) == NULL)
	  return(error("Could not open reply file"));

	/* make sure this twit really wants to send mail before we go any 
	   further! */

	generate_reply_to((is_a_response? current-1 : -1));

	edit_headers((is_a_response? current-1 : -1));

	if (check_first && ! batch) {
	  if (mail_only) {
	    printf("\n\rAre you sure you want to send this? (y/n) ");
	    CleartoEOLN();
	    printf("y%c", BACKSPACE);
	    fflush(stdin);	/* wait for answer! */
	    fflush(stdout);
	    if (tolower(ReadCh()) == 'n') { /* sigh... */
	      printf("No\n\r\n\r\n\rMail not sent!!\n\r");
	      return(0);
	    }
	    else
	      printf("Yes\n\r\n\r");
	  }
	  else {
	    MoveCursor(LINES,0);
	    CleartoEOLN();
	    MoveCursor(LINES-1,0);
	    printf("Are you sure you want to send this? (y/n) ");
	    CleartoEOLN();
	    printf("y%c", BACKSPACE);
	    fflush(stdin);	/* wait for answer! */
	    fflush(stdout);
	    if (tolower(ReadCh()) == 'n') { /* sigh... */
	      printf("No");
	      set_error(
           "Message kept - Can be restored at next F)orward, M)ail or R)eply ");
	      cancelled_msg = 1;
	      fclose(reply);
	      return(1);
	    }
	    printf("Yes!");
	    fflush(stdout);
	  }
	}

	cancelled_msg = 0;	/* it ain't cancelled, is it? */

	/** grab a copy if the user so desires... **/

	if (auto_cc && ! batch)
	  save_copy(subject, expanded_to, expanded_cc, filename, to);

	/** write all header information into real_reply **/

	sprintf(filename2,"%s%d",temp_file, getpid()+1);
	
	if ((real_reply = fopen(filename2,"w")) == NULL) {
	  /* contingency: use mailx... */
	  if (cc[0] != '\0')  		/* copies! */
	    sprintf(to,"%s %s", to, cc);

	  sprintf(very_long_buffer, "(%s -s \"%s\" %s < %s ; %s %s)&",
                  mailx, subject, strip_commas(to), filename, remove, filename);
	  error1("couldn't open %s for writing!", filename2);
	  sleep(2);	/* ensure time to see this prompt! */
	  
	}
	else {
	  /* write header to file then message... */

	  fprintf(real_reply, "To: %s\n", format_long(to, strlen("To:")));

	  fprintf(real_reply,"Date: %s\n", (char *) get_arpa_date());

	  fprintf(real_reply,"From: %s!%s (%s)\n", hostname, username,
		  full_username);

	  fprintf(real_reply, "Subject: %s\n", subject);

	  if (cc[0] != '\0')
	    fprintf(real_reply, "Cc: %s\n", 
		    format_long(cc, strlen("Cc: ")));

	  if (strlen(action) > 0)
	    fprintf(real_reply, "Action: %s\n", action);
	
	  if (strlen(priority) > 0)
	    fprintf(real_reply, "Priority: %s\n", priority);
	
	  if (strlen(expires) > 0)
	    fprintf(real_reply, "Expiration-Date: %s\n", expires);
	
	  if (strlen(reply_to) > 0)
	    fprintf(real_reply, "In-Reply-To: %s\n", reply_to);
	
	  /*** add the users .mailheaders file if available ***/

	  sprintf(hfname, "%s/%s", home, mailheaders);

	  if ((headerfile = fopen(hfname, "r")) != NULL) {
	    while (fgets(buffer, LONG_SLEN, headerfile) != NULL)
	      fprintf(real_reply, "%s", buffer);
	    fclose(headerfile);
	  }

	  fprintf(real_reply, "X-Mailer: msg [version %s]\n", VERSION);
	  fprintf(real_reply, "\n");

 	  /** now copy message across! **/

	  while (fgets(buffer, LONG_SLEN, reply) != NULL) {
	    if (buffer[0] == '[') {
	      if (strncmp(buffer, START_ENCODE, strlen(START_ENCODE))==0)
	        crypted = 1;
	       else if (strncmp(buffer, END_ENCODE, strlen(END_ENCODE))==0)
	        crypted = 0;
	       else if (strncmp(buffer, DONT_SAVE, strlen(DONT_SAVE)) == 0)
	        continue;	/* next line? */
	      }
	      else if (crypted) {
	        if (! gotten_key++)
	          getkey(ON);
	        else if (! encoded_lines++)
	          get_key_no_prompt();		/* reinitialize.. */
	        
		encode(buffer);
	      }
	    fputs(buffer, real_reply);
	  }

	  fclose(reply);
	  fclose(real_reply);

	  if (cc[0] != '\0')  /* copies! */
	    sprintf(to,"%s %s", to, cc);

	  if (access(sendmail, EXECUTE_ACCESS) == 0)	/* yeah!  Sendmail! */
	    sprintf(very_long_buffer,"(%s %s %s < %s ; %s %s) &",
                  sendmail, sendmailflags, strip_commas(to), filename2, 
		  remove, filename2);
	  else /* oh well, use default mailer... */
            sprintf(very_long_buffer,"(%s %s < %s ; %s %s) &", 
                  mailer, strip_commas(to), filename2, 
		  remove, filename2);
	}
	
	if (mail_only) {
	  if (! batch) {
	    printf("sending mail...");
	    fflush(stdout);
	  }
	}
	else {	
	  PutLine(LINES,0,"sending mail...");
	  CleartoEOLN();
	}

	dprint1("\n\n\t%s\n\n", very_long_buffer);
	system(very_long_buffer);

	if (mail_only) {
	  if (! batch)
	    printf("\rmail sent!      \n\r");
	}
	else 
	  set_error("Mail sent!");

	return(TRUE);
}
