/**			input_utils.c			**/

/** Mindless I/O routines for MSG 
	
    (C) Copyright 1985 Dave Taylor
**/

#include "headers.h"

int
want_to(s, def, echo_answer)
char *s, def;
int  echo_answer;
{
	/** ask 's' at 20,40, return answer in lower case.
	    If 'echo_answer', then echo answer.  'def' is the
  	    default answer if <return> is pressed.
	**/
	register char ch;

	if (strlen(s) < 30)
	  MoveCursor(LINES-3, COLUMNS-40);
	else
	  MoveCursor(LINES-3, COLUMNS-50);
	printf("%s%c%c", s, def, BACKSPACE);
	fflush(stdout);
	ch = tolower(ReadCh());

	if (echo_answer && ch > (char) ' ')
	  putchar(ch);

	return(ch);
}

int
read_number(ch, max)
char ch;
int max;
{
	/** read a number, where 'ch' is the leading digit! 
	    If max < 10 then just return 'ch' **/
	
	char buff[SHORT_SLEN];
	int  num;

	if (max < 10)
	  return( (int) ch - '0' );
	
	buff[0] = ch;
	buff[1] = '\0';

	PutLine(LINES-3, COLUMNS-40,"Set current message to :");
	if (optionally_enter(buff, LINES-3, COLUMNS-15, TRUE) == -1)
	  return(current);

	sscanf(buff,"%d", &num);
	return(num);
}

int
optionally_enter(string, x, y, append_current)
char *string;
int  x,y, append_current;
{
	/** Display the string on the screen and if RETURN is pressed, return 
	    it.  Otherwise, allow standard text input, including backspaces 
	    and such until RETURN is hit.  
	    If "append_current" is set, then leave the default string in 
	    place and edit AFTER it...assume 'x,y' is placing us at the
	    beginning of the string...
	    This routine returns zero unless INTERRUPT hit, then it returns
	    -1 and must be treated accordingly.
	**/

	char ch;
	register index = 0;

	MoveCursor(x,y);
	printf("%s", string);	
	CleartoEOLN();
	if (! append_current)
	  MoveCursor(x,y);

	if (cursor_control)
	  transmit_functions(OFF);

	ch = getchar();

	if (ch == '\n' || ch == '\r') {
	  if (cursor_control)
	    transmit_functions(ON);
	  return(0);	/* we're done.  No change needed */
	}
	
	CleartoEOLN();

	index = (append_current? strlen(string) : 0);

	if (ch == kill_line) {
	  if (! mail_only)
	    MoveCursor(x,y);
          CleartoEOLN();
	  index = 0;
	}
	else if (ch != backspace) {
	  putchar(ch);
	  string[index++] = ch;
	}
	else if (index > 0) {
	  index--;
	  putchar(BACKSPACE);
	  putchar(' ');
	  putchar(BACKSPACE);
	  fflush(stdout);
	}
	else {
	  putchar(' ');
	  putchar(BACKSPACE);
	  fflush(stdout);
	}

	do {
	  ch = getchar();

	  /* the following is converted from a case statement to
	     allow the variable characters (backspace, kill_line
	     and break) to be processed.  Case statements in
	     C require constants as labels, so it failed ...
	  */

	    if (ch == backspace) {
              if (index > 0) {
		index--;
		putchar(BACKSPACE);
		putchar(' ');
		putchar(BACKSPACE);
	        fflush(stdout);
	      }
	      else {
		putchar(' ');
		putchar(BACKSPACE);
	        fflush(stdout);
	      }
	    }
	    else if (ch == '\n' || ch == '\r') {
	      string[index] = '\0';
	      if (cursor_control)
	        transmit_functions(ON);
	      return(0);
	    }
	    else if (ch == kill_line) {
	      if (mail_only)
	        back_up(index+1);
	      else
	        MoveCursor(x,y);
              CleartoEOLN();
	      index = 0;
	    }
	    else if (ch == NULL) {
	      if (cursor_control)
	        transmit_functions(ON);
	      fflush(stdin); 	/* remove extraneous chars, if any */
	      string[0] = '\0'; /* clean up string, and... */
	      return(-1);
	    }
	    else {  /* default case */
		        
	      string[index++] = ch;
	      putchar(ch);
	   }
	} while (index < SLEN);

	string[index] = '\0';

	if (cursor_control)
	  transmit_functions(ON);
	return(0);
}


int
pattern_enter(string, alt_string, x, y, alternate_prompt)
char *string, *alt_string, *alternate_prompt;
int  x,y;
{
	/** This function is functionally similar to the routine
	    optionally-enter, but if the first character pressed
	    is a '/' character, then the alternate prompt and string
	    are used rather than the normal one.  This routine 
	    returns 1 if alternate was used, 0 if not
	**/

	char ch;
	register index = 0;

	dprint4("pattern_enter(string='%s', alt_string='%s', x=%d, y=%d,\n", 
		string, alt_string, x, y);
	dprint1("              alt-prompt='%s')\n", alternate_prompt);

	MoveCursor(x,y);
	printf("%s", string);	
	CleartoEOLN();
	MoveCursor(x,y);

	if (cursor_control)
	  transmit_functions(OFF);

	ch = getchar();

	if (ch == '\n' || ch == '\r') {
	  if (cursor_control)
	    transmit_functions(ON);
	  return(0);	/* we're done.  No change needed */
	}
	
	if (ch == '/') {
	  MoveCursor(x, 0);
	  CleartoEOLN();
	  printf("%s", alternate_prompt);
	  (void) optionally_enter(alt_string, x, strlen(alternate_prompt)+1,
		 FALSE);
	  return(1);
	}

	CleartoEOLN();

	index = 0;

	if (ch == kill_line) {
	  MoveCursor(x,y);
          CleartoEOLN();
	  index = 0;
	}
	else if (ch != backspace) {
	  putchar(ch);
	  string[index++] = ch;
	}
	else if (index > 0) {
	  index--;
	  putchar(BACKSPACE);
	  putchar(' ');
	  putchar(BACKSPACE);
	}
	else {
	  putchar(' ');
	  putchar(BACKSPACE);
	}

	do {
	  fflush(stdout);
	  ch = getchar();

	  /* the following is converted from a case statement to
	     allow the variable characters (backspace, kill_line
	     and break) to be processed.  Case statements in
	     C require constants as labels, so it failed ...
	  */

	    if (ch == backspace) {
              if (index > 0) {
		index--;
		putchar(BACKSPACE);
		putchar(' ');
		putchar(BACKSPACE);
	      }
	      else {
		putchar(' ');
		putchar(BACKSPACE);
	      }
	    }
	    else if (ch == '\n' || ch == '\r') {
	      string[index] = '\0';
	      if (cursor_control)
	        transmit_functions(ON);
	      return(0);
	    }
	    else if (ch == kill_line) {
	      MoveCursor(x,y);
              CleartoEOLN();
	      index = 0;
	    }
	    else if (ch == NULL) {
	      if (cursor_control)
	        transmit_functions(ON);
	      fflush(stdin); 	/* remove extraneous chars, if any */
	      string[0] = '\0'; /* clean up string, and... */
	      return(-1);
	    }
	    else {  /* default case */
		        
	      string[index++] = ch;
	      putchar(ch);
	   }
	} while (index < SLEN);

	string[index] = '\0';

	if (cursor_control)
	  transmit_functions(ON);
	return(0);
}

back_up(spaces)
int spaces;
{
	/** this routine is to replace the goto x,y call for when sending
	    mail without starting the entire "msg" system up... **/
	
	dprint1("back-up(spaces=%d)\n", spaces);

	while (spaces--) {
	  putchar(BACKSPACE);
	  putchar(' ');
	  putchar(BACKSPACE);
	}

	fflush(stdout);
}
