/**		initialize.c		**/

/***** Initialize - read in all the defaults etc etc 
       (C) Copyright 1985 Dave Taylor
*****/

#include <stdio.h>
#ifndef BSD
#  include <termio.h>
#endif
#include <pwd.h>
#ifdef BSD
#  include <sys/time.h>
#else
#  include <time.h>
#endif
#include <signal.h>
#include <errno.h>
#include <ctype.h>

#ifdef BSD
#undef tolower
#endif

#include "headers.h"

extern int errno;		/* system error number on failure */

initialize()
{
	struct passwd *pass, *getpwnam();

	register int i;
	int      leave();
	char     buffer[SLEN];
	
	userid = getuid();
	progid = geteuid();	

	strcpy(home,getenv("HOME"));
	strcpy(shell,getenv("SHELL"));

	if (debug) {		/* setup for dprintf statements! */
	  char filename[SLEN];
	  sprintf(filename, "%s/%s", home, DEBUG);
	  if ((debugfile = fopen(filename, "w")) == NULL) {
	    debug = 0;	/* otherwise 'leave' will try to log! */
	    leave(fprintf(stderr,"Could not open file %s for debug output!\n",
		  filename));
	  }
	  chown(filename, userid, getgid()); /* file owned by user */

	  fprintf(stderr,"\r\n** Debug output going to '%s' **\n\r", filename);
	  sleep(2);
	  fprintf(debugfile, "\nDebug output of MSG program, version %s\n\n",
		  VERSION);
	}

	signal(SIGINT,  SIG_IGN);
	signal(SIGQUIT, leave);
	signal(SIGTERM, leave); 

	read_lsys();

	get_term_chars();
	
	gethostname(hostname, sizeof(hostname));
	strcpy(username,getlogin());
	if (strlen(username) == 0)
	  cuserid(username);

	/* now let's get the full username.. */

	if ((pass = getpwnam(username)) == NULL) {
	  error("Couldn't read password entry??");
	  strcpy(full_username, username);
	}
	else {
	  for (i=0; pass->pw_gecos[i] != '\0' && pass->pw_gecos[i] != ',';
	       i++)
	      full_username[i] = pass->pw_gecos[i];
	  full_username[i] = '\0'; 
	}

	editor[0] = '\0';
	strcpy(editor,getenv("EDITOR"));
	if (editor[0] == '\0')
	  strcpy(editor,default_editor);

	if (! mail_only) {
	  mailbox[0] = '\0';
	  strcpy(prefixchars, "> "); 	/* default message prefix */
	}

	read_rc_file();		/* reading the .msgrc next... */

	/** check to see if the user has defined a LINES or COLUMNS
	    value different to that in the termcap entry (for
	    windowing systems, of course!) **/

	strcpy(buffer, getenv("LINES"));
	if (isdigit(buffer[0]))
	  sscanf(buffer, "%d", &LINES);

	strcpy(buffer, getenv("COLUMNS"));
	if (isdigit(buffer[0]))
	  sscanf(buffer, "%d", &COLUMNS);

	/** fix the shell if needed **/

	if (shell[0] != '/') {
	   sprintf(buffer, "/bin/%s", shell);
	   strcpy(shell, buffer);
	}

	if (! mail_only) {
	  mailbox_defined = (mailbox[0] != '\0'); 

	  /* now get the inverse video sequences from the termcap... */
	
	  strcpy(start_highlight, return_value_of("so"));
	  strcpy(end_highlight, return_value_of("se"));
  
	  /* get the cursor control keys... */

	  strcpy(up, return_value_of("ku"));

	  if (strlen(up) != 2)	 	/* don't want arbitrary length! */
	    cursor_control = FALSE;
	  else {
	    strcpy(down, return_value_of("kd"));
	    cursor_control = TRUE;
	    transmit_functions(ON);
	  }
	}

	if (read_aliases)
  	  read_alias_files();

	if (! mail_only) {
	  if (! mbox_specified)
	    newmbox(1,FALSE);	/* read the incoming mail mailbox! */
	  else
	    newmbox(0,FALSE);	/* read the specified mail file!   */

	  if (mini_menu)
	    headers_per_page = LINES - 13;
	  else
	    headers_per_page = LINES -  8;	/* 5 more headers! */
	}

	init_findnode();	/* set up the path alias stuff */

	dprint0("\n\n------ Past the Initialization stuff ------\n\n");

	dprint3("\nhostname = '%s'   username = '%s'   full_username = '%s'\n",
	         hostname, username, full_username);

	dprint3("home = '%s'   editor = '%s'   mailbox = '%s'\n",
		 home, editor, mailbox);
	
	dprint3("hp_terminal = %s, hp_softkeys = %s, and cursor_control=%s\n\n",
		onoff(hp_terminal), onoff(hp_softkeys), onoff(cursor_control));

}

get_term_chars()
{
	/** This routine sucks out the special terminal characters
	    ERASE and KILL for use in the input routine.  The meaning 
            of the characters are (dare I say it?) fairly obvious... **/

#ifndef BSD
	struct termio term_buffer;

	if (ioctl(STANDARD_INPUT, TCGETA, &term_buffer) == -1) {
	  dprint1("** Error %d encountered on initial ioctl call **\n", errno);
	  /* set to defaults for terminal driver */
#endif
	  backspace = BACKSPACE;
	  kill_line = ctrl('U');
#ifndef BSD
	}
	else {
	  backspace = term_buffer.c_cc[VERASE];
	  kill_line = term_buffer.c_cc[VKILL];
	}
#endif
}

read_lsys()
{
	/** Read the system L.sys file and put all the machine names in
	    the talk-to-sys linked list structure! **/

	FILE *lsysfile;
	char  buffer[SLEN], sysname[NLEN];
	struct lsys_rec *system_record, *previous_record;

	previous_record = NULL;

	if ((lsysfile = fopen(Lsys,"r")) == NULL) {
	  dprint1("\nCan't open L.sys file '%s' for reading!!\n\n",
		  Lsys);
	  error("Warning: couldn't read L.sys file...");
	  talk_to_sys = NULL;
	  return;
	}

	while (fgets(buffer, SLEN, lsysfile) != NULL) {
	  sscanf(buffer,"%s", sysname);

	  if (previous_record == NULL) {
	    dprint1("\tread '%s' out of L.sys file\n", sysname);
	    previous_record = (struct lsys_rec *) malloc(sizeof *talk_to_sys);

	    strcpy(previous_record->name, sysname);
	    previous_record->next = NULL;
	    talk_to_sys = previous_record;
	  }
	  else if (! talk_to(sysname)) {
	    dprint1("\tread '%s' out of L.sys file\n", sysname);
	    system_record = (struct lsys_rec *) malloc(sizeof *talk_to_sys);
	  
	    strcpy(system_record->name, sysname);
	    system_record->next = NULL;
	    previous_record->next = system_record;
	    previous_record = system_record;
	  }
	}

	fclose(lsysfile);
}
