
/**			hdrconfg.c			**/

/**   This file contains the routines necessary to be able to modify
      the mail headers of messages on the way off the machine.  The
      headers currently supported for modification are:

	Subject:
	To:
	Cc:

	Expiration-Date:
	Priority:
        In-Reply-To:
	Action:
	Security:
	
      (C) Copyright 1985, Dave Taylor
**/

#include <stdio.h>
#include "headers.h"

#include <ctype.h>

#ifdef BSD
#undef toupper
#endif

/* these are all defined in the mailout file! */

extern char subject[SLEN], action[SLEN], reply_to[SLEN], expires[SLEN], 
	    priority[SLEN];
extern char to[VERY_LONG_STRING], cc[VERY_LONG_STRING];

edit_headers(original_msg_num)
int   original_msg_num;
{
	/** edit headers, R)eturn to continue with mailing **/

	int unexpanded_to = TRUE, unexpanded_cc = TRUE;
	char c, expanded_to[VERY_LONG_STRING], expanded_cc[VERY_LONG_STRING];
	
	dprint1("edit_headers(original-msg-number=%d)\n", original_msg_num);


	if (! edit_outbound || mail_only) goto outta_here;

	display_headers();

	do {
	  PutLine(LINES-1,0,"Choice: ");
	  CleartoEOLN();
	  c = toupper(getchar());
	  clear_error();
	  switch (c) {
	    case ctrl('M'):
	    case 'R' :
	    case 'Q' : goto outta_here;
	    case ctrl('L') : display_headers();
		       break;
	    case 'T' : if (optionally_enter(to, 2, 9, TRUE) == -1)
	                 goto outta_here;
	    	       build_address(strip_commas(to), expanded_to);
		       unexpanded_to = FALSE; 
		       break;
	    case 'S' : if (optionally_enter(subject, 3, 9, FALSE) == -1)
			 goto outta_here;
		       break;
	    case 'C' : if (optionally_enter(cc, 4, 9, TRUE) == -1)
			 goto outta_here;
	  	       build_address(strip_commas(cc), expanded_cc);
		       unexpanded_cc = FALSE;
		       break;
	    case 'A' : if (optionally_enter(action, 6, 9, FALSE) == -1)
			 goto outta_here;
		       break;
	    case 'E' : enter_date(7, 17, expires);
		       break;
	    case 'P' : if (optionally_enter(priority, 9,10, FALSE) == -1)
			 goto outta_here;
		       break;
	    case 'I' : if (original_msg_num != -1) {
	                 if (optionally_enter(reply_to, 8,13, FALSE) == -1)
			   goto outta_here;
			 break;		
		       }
		       /** else fall through as an error **/
	    default  : error("Unknown header being specified!");
	  }
	} while (TRUE);

outta_here:	/* this section re-expands aliases before we leave... */

	if (unexpanded_to)
	  build_address(strip_commas(to), expanded_to);
	if (unexpanded_cc)
	  build_address(strip_commas(cc), expanded_cc);

	strcpy(to, expanded_to);
	strcpy(cc, expanded_cc);

	return;
}

display_headers()
{
	ClearScreen();

	Centerline(0,"Message Header Edit Screen");

	PutLine(2,0,"To     : %s", to);
	PutLine(3,0,"Subject: %s", subject);
	PutLine(4,0,"Cc     : %s", cc);
	PutLine(6,0,"Action :");
	PutLine(7,0,"Expiration-Date:");
	if (strlen(reply_to) > 0)
	  PutLine(8,0,"In-Reply-To: %s", reply_to);
	PutLine(9,0,"Priority:");

	Centerline(LINES-5, 
		"Pick the First Letter of the Header or R)eturn from Editing");
}

enter_date(x, y, buffer)
int x, y;
char *buffer;
{
	/** Enter the number of days this message is valid for, then
	    display at (x,y) the actual date of expiration.  This 
	    routine relies heavily on the routine 'days_ahead()' in
	    the file date.c
	**/

	int days;

	PutLine(LINES-1,0, "How many days in the future should it expire? ");
	CleartoEOLN();
	Raw(OFF);
	gets(buffer, SLEN);
	Raw(ON);
	sscanf(buffer, "%d", &days);
	if (days < 1)
	  error("That doesn't make sense!");
	else if (days > 14)
	  error("Expiration date must be within two weeks of today");
	else {
	  error1("days_ahead(%d)", days);
	  days_ahead(days, buffer);
	  PutLine(x, y, buffer);
	}
}
