/**		file.c		**/

/** File I/O routines, including deletion from the mailbox! 

    (C) Copyright 1986, Dave Taylor
**/

#include "headers.h"
#include <ctype.h>

#ifdef BSD
#undef tolower
#endif

int
save()
{
	/** save current message in file.  Append if possible!
	    Returns zero iff no file specified (cancelled command) **/

	char filename[SLEN], address[LONG_SLEN], buffer[SLEN];
	FILE *save_file;

	dprint0("save()\n");

	MoveCursor(LINES-2,0);
	printf("File current message in: ");

	if (save_by_name) {
	  /** build default filename to save to **/
	  get_return(address);
	  get_return_name(address, buffer);
	  sprintf(filename, "=/%s", buffer);
	}
	else
	  filename[0] = '\0';

	optionally_enter(filename, LINES-2, 25, FALSE);
	MoveCursor(LINES-1,0);

	if (strlen(filename) == 0)  /** <return> means 'cancel', right? **/
	  return(0);

	if (! expand_filename(filename))
	  return(0);	/* failed expanding name! */

	if ((save_file = fopen(filename,"a")) == NULL) {
	  error1("Couldn't append to file %s!", filename);
	  return(0); 
	}

	copy_message("", save_file, FALSE);

	fclose(save_file);

	chown(filename, getuid(), getgid());	/* owned by user */
	error1("Message saved in file %s", filename);
	return(1);
}

int
expand_filename(filename)
char *filename;
{
	/* expands '~' and '=' to specified file names, also will
	   try to expand shell variables if encountered.. */

	char buffer[SLEN], varname[SLEN], env_value[SLEN];
	register int i = 1, index = 0;

	dprint1("expand_filename(filename='%s')\n", filename);

	/** new stuff - make sure no illegal char as last **/

	if (lastch(filename) == '\n' || lastch(filename) == '\r')
	  lastch(filename) = '\0';
	  
	if (filename[0] == '~') {
	  sprintf(buffer, "%s%s%s", home, 
		(filename[1] != '/' && lastch(folders) != '/')? "/" : "",
	  	(char *) filename + 1);
	  strcpy(filename, buffer);
	}
	else if (filename[0] == '=') {
	  if (strlen(folders) == 0) {
	    error("MAILDIR not defined.  Can't expand '='");
	    return(0);
	  }
	  sprintf(buffer, "%s%s%s", folders, 
		(filename[1] != '/' && lastch(folders) != '/')? "/" : "",
		(char *) filename + 1);
	  strcpy(filename, buffer);
	}
	else if (filename[0] == '$') {	/* env variable! */
	  while (isalnum(filename[i]))
	    varname[index++] = filename[i++];
	  varname[index] = '\0';

	  strcpy(env_value, getenv(varname));

	  if (strlen(env_value) == 0) {
	    error1("Don't know what the value of $%s is!", varname);
	    return(0);
	  }

	  sprintf(buffer, "%s%s%s", env_value, 
		  (filename[i] != '/' && lastch(env_value) != '/')? "/" : "",
		  (char *) filename + i);
	  strcpy(filename, buffer);
	}
	  
	return(1);
}
