/**			alias.c			**/

/** This file contains alias stuff

    (C) Copyright 1986 Dave Taylor
**/

#include "headers.h"

char *expand_group(), *get_alias_address(), *expand_system(), *get_token();

read_alias_files()
{
	/** read the system and user alias files, if present.
	    Set the flags 'systemfiles' and 'userfiles' accordingly.
	**/

	char fname[SLEN];
	int  hash;

	dprint0("read_alias_files()\n");

	if ((hash = open(system_hash_file, O_RDONLY)) == -1) 
	  goto user;

	read(hash, system_hash_table, sizeof system_hash_table);
	close(hash);

	/* and data file opened.. */

	if ((system_data = open(system_data_file, O_RDONLY)) == -1) 
	  goto user;

	system_files++;	/* got the system files! */

user:   sprintf(fname,  "%s/.alias_hash", home); 

	if ((hash = open(fname, O_RDONLY)) == -1) 
	  return;

	read(hash, user_hash_table, sizeof user_hash_table);
	close(hash);

	sprintf(fname,  "%s/.alias_data", home); 

	if ((user_data = open(fname, O_RDONLY)) == -1) 
	  return;

	user_files++;	/* got user files too! */
}

int
add_alias()
{
	/** add an alias to the user alias text file.  Return zero 
	    if alias not added in actuality **/

	char name[SLEN], *address, address1[LONG_STRING];
	char comment[SLEN];

	dprint0("add_alias()\n");

	PutLine(LINES-2,0,"Enter alias name: ");
	CleartoEOLN();
	Raw(OFF);
	gets(name, 20);
	Raw(ON);
	if ((address = (char *) get_alias_address(name, 0, 0)) != NULL) {
	  if (address[0] == '!') {
	    address[0] = ' ';
	    error1("already a group with that name:%s", address);
	  }
	  else
	    error1("already an alias for that: %s", address);
	  return(0);
	}
	PutLine(LINES-2,0,"Full name for %s: ", name);
	CleartoEOLN();
	Raw(OFF);
	gets(comment,SLEN);
	Raw(ON);
	PutLine(LINES-2,0,"Enter address for %s: ",name);
	CleartoEOLN();
	Raw(OFF);
	gets(address1,LONG_SLEN);
	Raw(ON);
	add_to_alias_text(name, comment, address1);
	return(1);
}

int
add_current_alias()
{
	/** alias the current message to the specified name and
	    add it to the alias text file, for processing as
	    the user leaves the program.  Returns non-zero iff
	    alias actually added to file **/

	char name[SLEN], address1[LONG_STRING], *address;
	char comment[SLEN];

	dprint0("add_current_alias()\n");

	if (current == 0) {
	  error("No message to alias to!");
	  return(0);
	}
	
	PutLine(LINES-2,0,"Current message address aliased to: ");
	CleartoEOLN();
	Raw(OFF);
	gets(name, 20);
	Raw(ON);
	if ((address = (char *) get_alias_address(name, 0, 0)) != NULL) {
	  if (address[1] == '!') {
	    address[0] = ' ';
	    error1("already a group with that name:%s", address);
	  }
	  else 
	    error1("already an alias for that: %s", address); 
          return(0);
	}
	PutLine(LINES-2,0,"Full name of %s: ", name);
	CleartoEOLN();
	Raw(OFF);
	gets(comment, 40);
	Raw(ON);
	get_return(address1);	/* grab the return address of this message */
	optimize_return(address1);
	PutLine(LINES-2,0,"%s (%s) = %s", comment, name, address1);
	CleartoEOLN();
	add_to_alias_text(name, comment, address1);
	return(1);
}

add_to_alias_text(name, comment, address)
char *name, *comment, *address;
{
	/** add the data to the user alias text file... **/
	
	FILE *file;
	char fname[SLEN];
	
	dprint3("add_to_alias_text(name='%s', comment='%s', address='%s')\n", 
		 name, comment, address);

	sprintf(fname,"%s/.alias_text", home);
	
	if ((file = fopen(fname, "a")) == NULL)
	  return(error1("couldn't open %s to add new alias!", fname));

	fprintf(file,"%s : %s : %s\n", name, comment, address);
	fclose(file);

	chown(fname, userid, getgid());

	return(0);
}

show_alias_menu()
{
	MoveCursor(LINES-7,0); CleartoEOLN();	
	MoveCursor(LINES-6,0); CleartoEOLN();	
	MoveCursor(LINES-5,0); CleartoEOLN();
	
	PutLine(LINES-7,COLUMNS-45, "Alias commands");
	Centerline(LINES-5,
"A)lias current msg, Check a P)erson or S)ystem, M)ake new alias, or R)eturn"
	);
}

alias()
{
	/** work with alias commands... **/
	char name[NLEN], *address, ch, buffer[SLEN];
	int  newaliases = 0;

	dprint0("alias()\n");

	if (mini_menu)
	  show_alias_menu();

	define_softkeys(ALIAS);

	while (1) {
	  PutLine(LINES-3,0,"Alias: ");
	  CleartoEOLN();
	  ch = ReadCh();
	  MoveCursor(LINES-1,0); CleartoEOLN();
	  
	  switch (tolower(ch)) {
	    case 'a': newaliases += add_current_alias();	break;
	    case 'm': newaliases += add_alias(); 		break;

	    case RETURN:
	    case 'q':
	    case 'x':
	    case 'r': if (newaliases) install_aliases();
		      return;
	    case 'p': if (newaliases)
			error("Warning: new aliases not installed yet!");
		      PutLine(LINES-2,0,"Check for person: ");
		      CleartoEOLN();
		      Raw(OFF);
	              gets(name,NLEN);
		      Raw(ON);
		      if ((address = get_alias_address(name, 0, 0))!=NULL) {
	                if (address[0] == '!') {
	                  address[0] = ' ';
	                  PutLine(LINES-1,0,"Group alias:%-65.65s", address);
	                  CleartoEOLN();
		        }
			else
			  PutLine(LINES-1,0,"Aliased addresss: %-65.65s", 
			  address);
		      }
	              else
			error("not found");
		      break;

	    case 's': PutLine(LINES-2,0,"Check for system: ");
		      CleartoEOS();
		      Raw(OFF);
	              gets(name,NLEN);
		      Raw(ON);
		      sprintf(buffer, "(user)@%s", name);
	 	      address = (char *) expand_system(buffer, 0, FALSE);
		      if (strlen(address) > strlen(name) + 7)
		        PutLine(LINES-1,0,"Address is: %.65s", address);
		      else
		        error1("couldn't expand system '%s'", name);
		      break;

	    case '@': PutLine(LINES-2,0,"Fully expand alias: ");
		      CleartoEOS();
		      Raw(OFF);
	              gets(name,NLEN);
		      Raw(ON);
		      if ((address = get_alias_address(name, 1, 0)) != NULL) {
	                ClearScreen();
			PutLine(3,0,"Aliased address:\n\r%s", address);
	                PutLine(LINES-1,0,"Press <return> to continue: ");
			(void) getchar();
		      }
	              else
			error("not found");
		      break;
	    default : error("Invalid input!");
	  }
	}
}

install_aliases()
{
	/** run the 'newalias' program and install the newly
	    added aliases before going back to the main
	    program! 
	**/

	dprint0("install_aliases()\n");

	error("Adding new aliases...");
	if (system_call(newalias, SH) == 0) {
	  error("Re-reading the database in...");
	  read_alias_files();
	  set_error("New aliases installed successfully");
	}
	else
	  set_error("'newalias' failed.  Please check alias_text");
}
