/**			sysdefs.h			**/

/**  System level, configurable, defines for the MSG mail system.  **/

/**  (C) Copyright 1986 Dave Taylor                                **/

/** define the following if you think that the information in messages
    that have "Reply-To:" and/or "From:" fields with addresses will
    contain valid addressing information.  If this isn't defined, the
    calculated return address will ALWAYS be used instead.  (note that
    this doesn't necessarily proclude the use of G)roup replies).

#define USE_EMBEDDED_ADDRESSES	

**/

#define FIND_DELTA	10		/* byte region where the binary search
					   on the path alias file is fruitless 
                                           (can't be within this boundary)    */

#define MAX_HEADERS	500	/* max number of messages in one file!   */	
#define MAX_SALIASES	503	/* number of system aliases allowed      */
#define MAX_UALIASES	251	/* number of user aliases allowed 	 */
#define MAX_IN_WEEDLIST 50	/* max headers to weed out               */

#define MAX_HOPS	35	/* max hops in return addr to E)veryone  */

#define MAX_ATTEMPTS	6	/* #times to attempt lock file creation */

/** see leavembox.c to determine if this should be defined or not....The 
    default is to NOT have it defined.

#define REMOVE_AT_LAST

**/

#define DEFAULT_BATCH_SUBJECT  "no subject (file transmission)"

/** If you want to have the mailer know about valid mailboxes on the
    host machine (assumes no delivery agent aliases) then you should
    undefine this (the default is to have it defined)...

#define NOCHECK_VALIDNAME

**/

#define NOTES_HEADER		"/***** "
#define NOTES_FOOTER		"/* ---------- */"

#ifdef BSD
# define system_hash_file	"/usr/spool/mail/.alias_hash"
# define system_data_file	"/usr/spool/mail/.alias_data"
#else
# define system_hash_file	"/usr/mail/.alias_hash"
# define system_data_file	"/usr/mail/.alias_data"
#endif

#define pathfile		"/usr/lib/nmail.paths"

#define Lsys			"/usr/lib/uucp/L.sys"

/** where to put the output of the msg -d command... (in home dir) **/
#define DEBUG		"Msg.debug.info"

#define temp_file	"/tmp/snd."
#define temp_mbox	"/tmp/mbox."
#define temp_print      "/tmp/print."
#define mailtime_file	".last_read_mail"

#ifdef BSD
# define default_editor	"/usr/ucb/vi"
# define mailhome	"/usr/spool/mail/"
#else
# define default_editor	"/usr/bin/vi"
# define mailhome	"/usr/mail/"
#endif

#define sendmail	"/usr/lib/sendmail"
#define sendmailflags	"-oi"
#define mailer		"/bin/rmail"
#define mailx		"/usr/bin/mailx"

#define cutfile		"/usr/local/bin/cutfile"

#define helphome	"/usr/local/lib/"
#define helpfile	"msg-help.main"

#define msgrcfile	"/.msgrc"
#define mailheaders	".msgheaders"
#define unedited_mail	"emergency.mbox"
#define newalias	"newalias 1>&2 > /dev/null"

#define remove		"/bin/rm -f"		/* how to remove a file */
#define cat		"/bin/cat"		/* how to display files */
