/**		msg.h			**/

/**  header file for msg mail system.  **/

/**  (C) Copyright 1986, Dave Taylor   **/

#include <stdio.h>
#include <fcntl.h>

#include "../hdrs/curses.h"
#include "../hdrs/defs.h"

/******** static character string containing the copyright notice  *******/

static char copyright[] = { "(C) Copyright 1986, Dave Taylor" };

/******** global variables accessable by all pieces of the program *******/

int current = 0;		/* current message number  */
int header_page = 0;     	/* current header page     */
int last_header_page = -1;     	/* last header page        */
int message_count = 0;		/* max message number      */
int total_lines_in_file;    	/* number of lines in file */
int headers_per_page;		/* number of headers/page  */
char infile[SLEN];		/* name of current mailbox */
char hostname[SLEN];		/* name of machine we're on*/
char username[SLEN];		/* return address name!    */
char full_username[SLEN];	/* Full username - gecos   */
char home[SLEN];		/* home directory of user  */
char folders[SLEN];		/* folder home directory   */
char mailbox[SLEN];		/* mailbox name if defined */
char editor[SLEN];		/* editor for outgoing mail*/
char printout[SLEN];		/* how to print messages   */
char savefile[SLEN];		/* name of file to save to */
char prefixchars[SLEN];		/* prefix char(s) for msgs */
char shell[SLEN];		/* current system shell    */
char batch_subject[SLEN];	/* subject buffer for batchmail */

char start_highlight[SLEN],
     end_highlight[SLEN];	/* to delimit urgent msgs  */

char backspace,			/* the current backspace char */
     kill_line;			/* the current kill-line char */

char up[SHORT], down[SHORT];	/* cursor control seq's    */
int  cursor_control = FALSE;	/* cursor control avail?   */

char weedlist[MAX_IN_WEEDLIST][NLEN];
int  weedcount;

int file_changed = 0;		/* flag: true if infile changed     */
int mini_menu = 1;		/* flag: menu specified?	    */
int mbox_specified = 0;		/* flag: specified alternate mbox?  */
int check_first = 1;		/* flag: verify mail to be sent!    */
int auto_copy = 0;		/* flag: automatically copy source? */
int filter = 0;			/* flag: weed out header lines?	    */
int resolve_mode = 1;		/* flag: delete saved mail?	    */
int auto_cc = 0;		/* flag: mail copy to user?	    */
int noheader = 0;		/* flag: copy + header to file?     */
int title_messages = 0;		/* flag: title message display?     */
int edit_outbound = 0;		/* flag: edit outbound headers?	    */
int read_aliases = 1;		/* flag: read in alias files?	    */
int hp_terminal = 0;		/* flag: are we on HP term?	    */
int hp_softkeys = 0;		/* flag: are there softkeys?        */
int save_by_name = 0;		/* flag: save mail by login name?   */
int notesfile = 0;		/* flag: is input file from notes?  */
int mail_only = 0;		/* flag: send mail then leave?      */
int check_only = 0;		/* flag: check aliases then leave?  */
int move_when_paged = 0;	/* flag: move when '+' or '-' used? */

int debug = 0; 			/** default is no debug! **/

int mailbox_defined = 0;	/** mailbox specified?    **/

int LINES=23;			/** lines per screen      **/
int COLUMNS=80;			/** columns per page      **/

int size_of_pathfd;		/** size of pathfile, 0 if none **/

FILE *mailfile;			/* current mailbox file    */
FILE *debugfile;		/* file for debug output   */
FILE *pathfd;			/* path alias file         */

struct header_rec header_table[MAX_HEADERS];

struct alias_rec user_hash_table[MAX_UALIASES];
struct alias_rec system_hash_table[MAX_SALIASES];

struct date_rec last_read_mail; /* last time we read mailbox  */

struct lsys_rec *talk_to_sys;   /* what machines do we talk to? */

struct addr_rec *alternative_addresses;	/* how else do we get mail? */

int system_files = 0;		/* do we have system aliases? */
int user_files = 0;		/* do we have user aliases?   */

int system_data;		/* fileno of system data file */
int user_data;			/* fileno of user data file   */

int userid;			/* uid for current user	      */
int progid;			/* euid for program	      */
