/**		headers.h		**/

/**  header file for msg mail system.  **/

/**  (C) Copyright 1985, Dave Taylor   **/

#include <stdio.h>
#include <fcntl.h>

#include "curses.h"
#include "defs.h"

/******** global variables accessable by all pieces of the program *******/

extern int current;		/* current message number  */
extern int header_page;         /* current header page     */
extern int last_header_page;    /* last header page        */
extern int message_count;	/* max message number      */
extern int total_lines_in_file;	/* number of lines in file */
extern int headers_per_page;	/* number of headers/page  */
extern char infile[SLEN];	/* name of current mailbox */
extern char hostname[SLEN];	/* name of machine we're on*/
extern char username[SLEN];	/* return address name!    */
extern char full_username[SLEN];/* Full username - gecos   */
extern char home[SLEN];		/* home directory of user  */
extern char folders[SLEN];	/* folder home directory   */
extern char mailbox[SLEN];	/* mailbox name if defined */
extern char editor[SLEN];	/* default editor for mail */
extern char printout[SLEN];	/* how to print messages   */
extern char savefile[SLEN];	/* name of file to save to */
extern char prefixchars[SLEN];	/* prefix char(s) for msgs */
extern char shell[SLEN];	/* default system shell    */
extern char batch_subject[SLEN];/* subject buffer for batchmail */

extern char start_highlight[SLEN],
	    end_highlight[SLEN]; /* to delimit urgent messages */

extern char backspace,		/* the current backspace char  */
	    kill_line;		/* the current kill_line char  */

extern char up[SHORT], 
	    down[SHORT];	/* cursor control seq's    */
extern int  cursor_control;	/* cursor control avail?   */


/** the following two are for arbitrary weedout lists.. **/

extern char weedlist[MAX_IN_WEEDLIST][NLEN];
extern int  weedcount;		/* how many headers to check?        */

extern int  file_changed;	/* flag: true iff infile changed      */
extern int  mini_menu;		/* flag: display menu?     	      */
extern int  mbox_specified;     /* flag: specified alternate mailbox? */
extern int  check_first;	/* flag: verify mail to be sent!      */
extern int  auto_copy;		/* flag: auto copy source into reply? */
extern int  filter;		/* flag: weed out header lines?	      */
extern int  resolve_mode;	/* flag: resolve before moving mode?  */
extern int  auto_cc;		/* flag: mail copy to yourself?       */
extern int  noheader;		/* flag: copy + header to file?       */
extern int  title_messages;	/* flag: title message display?       */
extern int  edit_outbound;	/* flag: edit outbound headers?       */
extern int  read_aliases;	/* flag: read in alias files??	      */
extern int  hp_terminal;	/* flag: are we on an hp terminal?    */
extern int  hp_softkeys;	/* flag: are there softkeys?          */
extern int  save_by_name;  	/* flag: save mail by login name?     */
extern int  notesfile;		/* flag: is input file from notes?    */
extern int  mail_only;		/* flag: send mail then leave?        */
extern int  check_only;		/* flag: check aliases and leave?     */
extern int  move_when_paged;	/* flag: move when '+' or '-' used?   */

extern int debug;		/** debugging mode on?  **/

extern int mailbox_defined;	/** specified mailbox?  **/

extern int LINES;		/** lines per screen    **/
extern int COLUMNS;		/** columns per line    **/

extern int size_of_pathfd;	/** size of pathfile, 0 if none **/

extern FILE *mailfile;		/* current mailbox file    */
extern FILE *debugfile;		/* file for debut output   */
extern FILE *pathfd;		/* path alias file         */

extern struct header_rec header_table[MAX_HEADERS];

extern struct alias_rec user_hash_table  [MAX_UALIASES];
extern struct alias_rec system_hash_table[MAX_SALIASES];

extern struct date_rec last_read_mail;

extern struct lsys_rec *talk_to_sys;	/* who do we talk to? */

extern struct addr_rec *alternative_addresses;	/* how else do we get mail? */

extern int system_files;	/* do we have system aliases? */
extern int user_files;		/* do we have user aliases?   */

extern int system_data;		/* fileno of system data file */
extern int user_data;		/* fileno of user data file   */

extern int userid;		/* uid for current user	      */
extern int progid;		/* euid for program	      */
