/*
 * usage:
 *      from [-f] [file] [-d] [-w] [-s sender] [-u user]
 *
 * caveats/comments:
 *	no checking is done w.r.t. what other programs are doing to the 
 *	mailboxes.
 *
 * author:
 *	Kevin Sweet ---------------------------------- sweet@scubed.arpa
 *	S-CUBED, 3398 Carmel Mountain,  San Diego, CA 92121-1095
 *	(home)  12205 Carmel Vista 242, San Diego, CA 92130-2237
 *	------- [ames,att,harvard,rutgers,ucsd,uunet]scubed!sweet ------
 *
 * This work is copyright 1988 by Kevin Sweet. Permission is granted 
 * to modify and distribute this work under the provision that the 
 * author is informed of any non-cosmetic changes to the code and that 
 * the author's name remain part of the documentaion. 
 */

#ifdef SYSV
# define MAXPATHLEN	1024
# include <string.h>
# define index		strchr
# define rindex		strrchr
#else
# include <sys/param.h>
# include <strings.h>
#endif
#include <stdio.h>

extern char *getenv();
static char *getmbox();
static int gethelp();

#define FORWARD		0
#define LSIZE		256
#define NUMQ		256
#define SWITCHAR	'-'

struct mbox {
	char from[LSIZE];
	char subject[LSIZE];
};

main(argc, argv)
int argc;
char *argv[];
{
	FILE *fp;
	char line[LSIZE], mbox[MAXPATHLEN], path[LSIZE], sender[LSIZE];
	register char *bang, *cp;
	register int DATE, SENDER, WIDE, 
	             from, i, j, left, mcnt, subject;
	struct mbox mail[NUMQ];

	/* find the mail file to list along with any options
	 */
	strcpy(mbox, "\0");
	DATE = SENDER = WIDE = 0;
	for (i = 1, cp = argv[1]; i < argc; i++, cp = argv[i]) {

		if (cp[0] == SWITCHAR) 
		switch (cp[1]) {
		case 'h': case 'H': 
			gethelp(argv[0], 0);
		case 'd': case 'D': 
			DATE = 1;
			break;
		case 'w': case 'W': 
			WIDE ++;
			if (cp[2] == 'w' || cp[2] == 'W') WIDE++;
			break;
		case 'f': case 'F': 
			if (cp[2]) 
				strncpy(mbox, &argv[i][2], MAXPATHLEN);
			else 
			if (i != argc-1 && argv[i+1][0] != SWITCHAR) {
				strncpy(mbox, argv[i+1], MAXPATHLEN);
				i++;
			}
			else 
			strncpy(mbox, getmbox(), MAXPATHLEN);
			break;
		case 's': case 'S': 
			if (cp[2]) 
				strncpy(sender, &argv[i][2], LSIZE);
			else 
			if (i != argc-1 && argv[i+1][0] != SWITCHAR) {
				strncpy(sender, argv[i+1], LSIZE);
				i++;
			}
			else 
#ifdef SYSV
			strncpy(sender, getenv("LOGNAME"), LSIZE);
#else
			strncpy(sender, getenv("USER"), LSIZE);
#endif
			SENDER = strlen(sender);
			break;
		case 'u': case 'U': 
			if (cp[2]) {
				strncpy(mbox, MAILDIR, MAXPATHLEN);
				strncat(mbox, &argv[i][2], 
				        MAXPATHLEN - strlen(mbox));
			}
			else 
			if (i != argc-1 || argv[i+1][0] != SWITCHAR) {
				strncpy(mbox, MAILDIR, MAXPATHLEN);
				strncat(mbox, argv[i+1], 
				        MAXPATHLEN - strlen(mbox));
				i++;
			}
			else
			strcpy(mbox, "\0");
			break;
		default: 
			printf("invalid option '%c': ", cp[1]);
			gethelp(argv[0], -1);
		}	/* end if/switch */
		else 
		strncpy(mbox, argv[i], MAXPATHLEN);

	}	/* end for */

	/* use the system mailbox if there are no arguments or if 
	 * there are any (fatal) errors
	 */
	if (!strlen(mbox)) {
		strncpy(mbox, MAILDIR, MAXPATHLEN);
#ifdef SYSV
		strncat(mbox, getenv("LOGNAME"), 
#else
		strncat(mbox, getenv("USER"), 
#endif
		        MAXPATHLEN - strlen(mbox));
	} 

	/* if we can't open the mailbox, exit quitely
	 */
	fp = fopen(mbox, "r");
	if (!fp) exit(1);

	/* read in the sender and subject of each letter
	 */
	mcnt = -1;
	while ( cp = fgets(line, LSIZE, fp) ) {
		cp[strlen(line)-1] = '\0';
		if (!strncmp(line, "From ", 5)) {
			if (mcnt >= 0 && !strlen(mail[mcnt].from)) 
			   strcpy(mail[mcnt].from, path);
			strcpy(path, index(line, ' ')+1);
			if (!DATE) {
				cp = index(path, ' ');
				if (cp) cp[0] = '\0';
			}
			if (SENDER) {
				from = 1;
				subject = 1;
				cp = path;
				j = 0;
				for (; *cp; *cp++) 
				if (!strncmp(cp, sender, SENDER)) j++;
			} else 
			j = 1;
			if (j) {
				mcnt++;
				from = 0;
				subject = 0;
			}
		} else 
		if (!from && ( !strncmp(line, "From: ", 6) || 
		    !strncmp(line+1, "From: ", 6) )) {
			if (!FORWARD) from = 1;
			if (DATE || WIDE > 1) {
				strcpy(mail[mcnt].from, path);
				continue;
			}
			cp = index(line, '<');
			if (cp) *cp++;
			else cp = index(line, ' ')+1;
			strcpy(mail[mcnt].from, cp);
			cp = index(mail[mcnt].from, '>');
			if (!cp) cp = index(mail[mcnt].from, ' ');
			if (cp) cp[0] = '\0';
		} else 
		if (!subject && !strncmp(line, "Subject: ", 9)) {
			if (!FORWARD) subject = 1;
			strcpy(mail[mcnt].subject, index(line, ' ')+1);
			if (DATE && !WIDE) 
			   strcpy(mail[mcnt].subject, "\0");
		} 
	}
	if (!strlen(mail[mcnt].from)) strcpy(mail[mcnt].from, path);

	/* display each entry: 
	 * if this isn't a wide list, use the shortest available name 
	 * for the sender and make sure that the subject does not 
	 * wrap 80 columns 
	 */
	for (i = 0; i <= mcnt; i++) {
		cp = index(mail[i].from, '!');
		bang = rindex(mail[i].from, '!');
		if (!DATE && WIDE < 2) {
			if (!bang || !strcmp(cp, bang)) 
			   cp = mail[i].from;
			else 
			{
				cp++;
				while (strcmp(index(cp, '!'), bang)) {
					cp = index(cp, '!');
					cp++;
				}	/* end while */
			}
		} else 
	       	cp = mail[i].from;
		left = 71 - (int) strlen(cp);
		printf("From %s", cp);
		if (DATE && !WIDE) putchar('\n');
		else 
		if (strlen(mail[i].subject)) {
			printf(", ");
			if (!WIDE) {
				putchar('"');
				cp = mail[i].subject;
				for (j = 0; j < left; j++) 
				    if (*cp) putchar(*cp++);
				printf("\"\n");
			} else 
			printf("\"%s\"\n", mail[i].subject);
		} 
		else
		printf(", (no subject)\n");
	} 

	fclose(fp);
}

static 
char *
getmbox()
{
	FILE *fp;
	char line[LSIZE], mailrc[MAXPATHLEN], mbox[MAXPATHLEN];
	register char *cp;

	/* find out where to look for mail startup file
	 */
	strncpy(mailrc, getenv("HOME"), MAXPATHLEN);
	strncat(mailrc, "/.mailrc", MAXPATHLEN - strlen(mailrc));
	if (getenv("MAILRC")) 
		strncpy(mailrc, getenv("MAILRC"), MAXPATHLEN);

	/* find out where to look for the default mailbox
	 */
	strncpy(mbox, getenv("HOME"), MAXPATHLEN);
	strncat(mbox, "/mbox", MAXPATHLEN - strlen(mbox));
	fp = fopen(mailrc, "r");
	if (fp) {
		while ( cp = fgets(line, LSIZE, fp) ) {
			cp[strlen(line)-1] = '\0';
			if (strncmp(line, "set MBOX=", 9)) continue;
			cp += 9;
			strncpy(mbox, cp, MAXPATHLEN);
			break;
		}
		fclose(fp);
	}
	if (getenv("MBOX")) 
		strncpy(mbox, getenv("MBOX"), MAXPATHLEN);

	return(mbox);
}

/* the help/usage message 
 */
static 
int 
gethelp(program, exit_status)
char *program;
int exit_status;
{
	register char *name;

	name = rindex(program, '/');
	if (name) *name++;
	else {
		name = rindex(program, '\\');
		if (name) *name++;
		else name = program;
	}
	printf("usage: %s [-f] [file] ", name);
	printf("[-d] [-w] [-s sender] [-u user]\n");
	exit(exit_status);
}

