/*
      Strings2 - Provides even more string functions for C.
      I don't know why these weren't included in strings(3).

      John Antypas -- ...!sdcsvax!jantypas
      
     strword1(r,s,c,i) -- Returns 1st word in s to r.  c is the character
                          which separates words.
     strindex(s,t) -- returns first occurrence of t in s or -1.
     strreplace(s,p,r) -- replace first pattern p with pattern r.
          This can be used to strinsert and delete functions.
          It returns a pointer to the new string s.

     All parameters are character pointers.

*/

#define		NULL	0

#if USG
#include	<string.h>	/* Need strcat, strcpy	*/
#else
#include	<strings.h>
#endif

int	strindex(s,t)
char *s, *t;
{
	int loop, n;		/* Loop counter		*/

	n = strlen(t);
	for (loop=0; s[loop] != '\0'; loop++)
	{
        if ((strncmp(s+loop, t, n) == 0) && (n != 0)) { return(loop); }
	}
	return (-1);
}

char	*strreplace(s,p,r)
char	*s, *p, *r;
{
	int	f, n;
	char	*m;		/* Used for temporary	*/

	m = (char *)malloc( strlen(s) + strlen(r) - strlen(p) );
	/* Get enough memory for the new string		*/
	/* If it doesn't work, die here			*/
	if (m == NULL) return(m);

	f = strindex(s,p);
	strncpy(m,s,f);	/* Copy up to p.	*/
	strcat(m,r);		/* Add in r.		*/
	
        /* Now add the part after the replacement	*/
	strcat(m,s+f+strlen(p));
	/* Copy it back to s				*/
	strcpy(s,m);
	free(m);
	return(s);
}

int	strword(r,s,c,i)
char	*s, *r, c;
int	i;
/*
	Function: Returns number of words/specific word in string s.
                  Returns in string r the word requested.  If i<0;
                  returns # words in s, else reurns ith word in r.
		  c is the character used to mark separate words.
		  Usually is a space (32).
*/
{
	int l;

	l = strlen(s);
	if (i<0)		/* Count words		*/
	{
		int nw,j;	/* # words and loop var	*/

		for (j=0,nw=0; j<l; j++)
		{
			if (*(s+j) == c) nw++;
		}
		if (nw != 0) nw++;
		return(nw);
	}
	else
	{
		char *sp,t[2];
		int nw,m;		/* Loops and length(s)	*/

		t[0] = c;  t[1] = 0;
		/* Find begining of ith word		*/
		nw = 0; sp = s;
		while ((nw<i) && (*sp != NULL))
		{
			if ((*sp) == c) nw++;
			sp++;
		}
		/* Now find end of that word		*/
		m = strindex(sp,t);
		if (m>0) { strncpy(r,sp,m); } else { strcpy(r,sp); }
		return(0);
	}
}
