/*
 * Message - Gathers incoming mail and sends it to be processed
 * John Antypas
 * ...!ucbvax!ucdavis!ucrmath!hope!jantypas
 *
 * For each message in the input stream, separate off the message and
 * record the following:
 * 
 * From line:
 * user
 * Subject
 *
 * And then process any message for twits and @ commands.
 *
 */
# include <stdio.h>		/* System file and string routines	*/
# include <sys/types.h>
# if USG
# include <string.h>
# else
# include <strings.h>
# endif
# include <fcntl.h>
# include <errno.h>
# include "typedefs.h"
# include "globals.var"
# include "process.h"

extern	mep_init();

/* Error message,  Print message in s and return value v to shell */
error(s,v)
char	s[];
int	v;
{
	fprintf(stderr,"ERROR: \007%s\n",s);
	fprintf(stderr,"MEP returning to shell!\n");
	exit(v);
}

main(argc,argv)
int	argc;
char	*argv[];
{
	FILE	*fp;
	int	pp;
	char	fname[80];
	
	strcpy(fname,mktemp(MEPTEMP));
	fp = fopen(fname,"a");
	fgets(linebuffer,512,stdin);
	while (!feof(stdin))
	{
		fputs(linebuffer,fp);
		fgets(linebuffer,512,stdin);
	}
	fclose(fp);
	pp = fork();
	if (pp == 0)
	{
		mep(fname);
	}
	exit(0);
}

mep(mailfile)
char	mailfile[];
{
	char	*c, buffer[80];
	FILE	*inf;	/* Spool file	*/
	int	gfd;		/* Generic file descripter	*/
	int loop;
	int id;
	
	id = getuid();
	mep_init(id);
	firstmessage	= TRUE;	/* No messages read yet		*/
	inf = fopen(mailfile,"r");
	while (!feof(inf)) /* As long as we have input	*/
	{
		fgets(linebuffer,512,inf);	/* Get line	*/
		/* Now see if this is a From line		*/
		/* If it is a From line, word = 'From '		*/
		if ((strncmp(linebuffer, "From ", 5) == 0) &&
		    (strlen(linebuffer) > 5))
		{
			/* Now see if this is our first From	*/
			if (!firstmessage)
			{
				/* This is after a previous 	*/
				/* Message, process the old one	*/
				fclose(md);
				process_message();
				strcpy(namem,mktemp(MEPTEMP));
				md = fopen(namem,"w+");
			}
			/* New message, so open needed files,	*/
			/* and start gathering fields etc.	*/
			c = linebuffer;
			c += 5;
			strcpy(fromline,c);
			fromline[strlen(fromline)-1] = 0;
			for (loop = 0; (fromline[loop] != ' ') 
				&& (fromline[loop] != '\0'); loop++) ;
			fromline[loop] = '\0';
			strcpy(namem,mktemp(MEPTEMP));
			md = fopen(namem,"w+");
			firstmessage = FALSE;
		}
		/* Not a from line so check To:/Subject:	*/
		if (strncmp(linebuffer, "To:", 3) == 0)
		{
			c = linebuffer; c += 3;
			strcpy(toline,c);
			toline[strlen(toline)-1] = 0;
		}
		/* Not a To: line so check subject		*/
		if (strncmp(linebuffer, "Subject:", 8) == 0)
		{
			c = linebuffer;
			if (strlen(linebuffer) > 9) 
			{ c += 9; } else {c += 8; }
			strcpy(subline,c);
			subline[strlen(subline)-1] = 0;
		}
		/* Not any of these so just copy to message	*/
		if (!feof(inf))
		{
			fputs(linebuffer,md);
		}
	}
	if (!firstmessage) 
	{
		fclose(md);
		process_message();
	}
	unlink(mailfile);
	exit(0);
}
