# include <stdio.h>
# include <pwd.h>
# include <utmp.h>
# if USG
# include <string.h>
# else
# include <strings.h>
# endif
# include "typedefs.h"
# include "globals.h"
/*
 * MepInit -- Will load configuration options at runtime
 *
 */

kill_newline(buffer)
char	*buffer;
{
	int i;

	for (i = 0; i< strlen(buffer); i++)
	{
		if (buffer[i] == '\n') 
		{
			buffer[i] = '\0';
			break;
		}
	}
}

parse_config(line, s)
char	line[];
struct persons *s;
{
	char	*c;
	int	s1,s2;	/* Slash pointers	*/

	c = line;
	/* Find position of slashes for later processing	*/
	s1 = strindex(c,"/");		/* Slash 1*/
	if (s1 == 0)
	{
		strcpy(s->pattern,"EMPTY");
	} else
	{
		strncpy(s->pattern,line,s1);
	}
	c += s1 +1;
	s2 = strindex(c,"/");
	if (s2 == 0)
	{
		s->op = 'S';
	} else
	{
		s->op = line[s1+s2];
	}
	c += s2+1;
	kill_newline(c);
	if (strlen(c) == 0)
	{
		strcpy(s->path,"");
	} else
	{
		strcpy(s->path,c);
	}
}
	
char	*logged(name)
char	name[];
{
	long	int	i,	size;
	struct	utmp	rec;
	FILE	*fp, *fopen();
	static	char terminal[9];

	fp = fopen("/etc/utmp","r");
	fseek(fp, 0L, 2);
	size = ftell(fp);
	rewind(fp);
	for (i = 0; i< (size/sizeof(rec)); i++)
	{
		fread(&rec,sizeof(rec),1,fp);
		if (strncmp(rec.ut_name,name,8) == 0)
		{
			strncpy(terminal,rec.ut_line,8);
			terminal[8] = '\0';
			fclose(fp);
			return(&terminal[0]);
		}
	}
	fclose(fp);
	return(NULL);
}

read_config()
{
	int	result;
	FILE	*fp, *gp, *fopen();
	char	buffer[512];
	char	buffer2[80];
	char	*c;
	char ttyname[32];
	
	result = chdir(homedir);
	fp = fopen(MEPCONFIG,"r");
	if (fp != NULL)
	{
		fgets(buffer,512,fp);
		kill_newline(buffer);
		while (!feof(fp))
		{
			if (strncmp(buffer,"biff=",5) == 0)
			{
				strcpy(buffer2,&buffer[5]);
				if (strcmp(buffer2,"yes") == 0)
				{ biffer = TRUE;   	} else 
				{ biffer = FALSE;	}
			}
			if (strncmp(buffer,"notify=",7) == 0)
			{
				strcpy(buffer2,&buffer[7]);
				if (strcmp(buffer2,"yes") == 0)
				{ notify = TRUE; } else { notify = FALSE; }
			}
			if (strncmp(buffer,"stat=",5) == 0)
			{
				strcpy(buffer2,&buffer[5]);
				if (strcmp(buffer2,"none") == 0)
				{
					log = FALSE;
				}
				else
				{
					log = TRUE;
					strcpy(logfile,&buffer[5]);
				}
			}
			fgets(buffer,512,fp);
			kill_newline(buffer);
		}
		fclose(fp);	
	} else
	{
		log = FALSE;
		notify = FALSE;
	}
}

mep_init(id)
int id;
{
	int	result;
	char	*p;
	char	buffer[80];
	char	envvalue[80];	/* Variable value	*/
	FILE	*fp, *fopen();
	struct passwd entry;
	
	/* Go to home and try to get the variables */
 	MEMCPY(&entry, getpwuid(id), sizeof(entry));
	strncpy(username,entry.pw_name,8);
	p = entry.pw_dir;
	if (p == NULL)
		error("Can't find home directory!",-1);
	strcpy(envvalue,p);
	result = chdir(envvalue);	/* Change to dir	*/
	if (result != 0)
	{
		fprintf(stderr,"Tried to switch to %s\n",envvalue);
		fprintf(stderr,"Got %d\n",result);
		error("Can't switch to home directory!",-1);
	}
	strcpy(homedir,envvalue);
	strcpy(username,entry.pw_name);

	read_config();
	result = chdir(homedir);
	/*
		 Only 100 twits allowed please.  If you have more 
		than 100 people you don't want mail from, you need
		an agent, not a mail extension
	*/
	num_twits = 0;	/* We assume no twits for now	*/
	fp = fopen(MEPTWIT,"r");
	if (fp == NULL) { /* No twits lucky you	*/ }
	else	/* Oh well, you can't expect perfection	*/
	{
		strcpy(twitlist[0].pattern,"TWITS");
		twitlist[0].op = 'D';
		strcpy(twitlist[0].path,"");
		while (!feof(fp))
		{
			num_twits++;
			fgets(buffer,80,fp);
			parse_config(buffer,&twitlist[num_twits]);
		}
		fclose(fp); 
	}
	num_cmds = 0;
	fp = fopen(MEPCOMMAND,"r");
	if (fp == NULL) { /* No stuff OK */ }
	else
	{
		strcpy(comlist[0],"");
		while (!feof(fp))
		{
			num_cmds++;
			fgets(buffer,80,fp);
			buffer[strlen(buffer)-1] = 0;
			strcpy(comlist[num_cmds],buffer);
		}
		fclose(fp);
	}
}
