xfile="mailsplit"
echo "Extracting $xfile (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >$xfile <<!GROK!THIS!
$startsh

##############################################################################
# These commands and paths should be configured for your machine/site

PATH="/bin:/usr/bin:/usr/local/bin:/usr/ucb:/usr/local:/usr/lbin:/etc:\\
/usr/new:/usr/new/bin:/usr/nbin:/usr/ucb/bin:/usr/old"
BASENAME=$basename
CAT=$cat
RM=$rm
MV=$mv
SPLIT=$split
TA=$tar              # Archive command (assumed here to be in search path!)
CO=$compress         # Default compress command  (assumed to be in search path!)
CE=$CE		     # compress'd file name extension
MA=$Mail             # Default Mail program
UU=$uuencode         # uuencode command (assumed here to be in search path!)
CB=$CB               # Default number of bits to use in compress
CF=$CF               # Default compress command line flag(s)
MS=$MS               # Mailer Subject line flag
DE=$DE               # Default delay time between sending pieces
TD=$TD               # Default temporary directory for storing temp files
DB=$DB               # Default debugging level
SPRT="_"	     # Separator for archive file name
#			;; Added by yamanaka@iias.fujitsu.co.jp
##############################################################################
!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>$xfile <<'!NO!SUBS!'
#
# mailsplit:  package, transmit, re-assemble unix directories via e-mail
#
# @(#)mailsplit.SH    2.7    90/03/28       M F Wyle, H. Yamanaka
#
# $Id: mailsplit.SH,v 1.8 90/03/19 22:40:14 yamanaka Rel $
#
# Add -A option and strip dirnames of commands
#			 90/01/25       H Yamanaka


##############################################################################
# You might want to change these, but it's not likely.

ME=`$BASENAME $0`   # Program (my) name
LI=700              # Default number of lines for split-up pieces
CM="$0 $*"          # Command line
VE="2.7  90/03/28"  # Version of this program
MF=""               # Default Mailer flags
IJ="true"           # Flag which signals if joinr script should be prepended
TM=false            # Default test Mode flag (If set, don't do anything)
T1=$TD/1sp$$        # Default temp file for output of tar, compress
T2=$TD/2sp$$        # Default temp file for uuencoded output
T3=$TD/3sp$$        # Default temp file prefix for split pieces
T4=$TD/4sp$$        # a copy of joinr
##############################################################################

# You do NOT want to change these variables or their initial values!

RA=all              # Default range of pieces to send
FC=0                # File Count
ne="FL=$FL' '"      # Next command in parser
SU="_default_"      # Default Subject is first file or dir sent
FL=""               # Initialize file list
TO=""               # Initialize recipient
umask 0             # Important for writing reading files created!

# Human Factors Law Number 4:  
# "Upon startup, thou shalt tell the user where he is and how to quit."
#           -Ben Schneiderman-

echo " " 1>&2
echo "$ME version $VE  (C) 1988, 1989, 1990    M F Wyle, H. Yamanaka" 1>&2
echo " " 1>&2

##############################################################################
# Read beyond here at your own risk; you've entered... The hacker zone...
# Parse the command line for recipient, options, flags, files, dirs:

for AR in $* ; do
  case $AR in
    -C  ) ne="CO=" ;;
    -D  ) ne="TD=" ;;
    -M  ) ne="MF=" ;;
    -N  ) IJ="false" ;;
    -A  ) MS="archive" ;;
    -T  ) ne="TA=" ;;
    -V  ) DB=9     ;;
    -b  ) ne="CB=" ;;
    -d  ) ne="DE=" ;;
    -l  ) ne="LI=" ;;
    -m  ) ne="MA=" ;;
    -n  ) TM=true  ;;
    -r  ) ne="RA=" ;;
    -s  ) ne="SU=" ;;
    -t  ) TM=true ;;
    -v  ) echo "$ME version $VE by Mitch Wyle" ;  exit 0 ;;
    -x* ) DB=`echo $AR | cut -c3` ; DB=${DB:-0} ;;
    -u  ) ne="UU=" ;;
    -*  ) echo " " ; echo "Bad flag for $ME": $AR
          echo "Usage:    $ME  [<options>] <mailpath> <file(s)>"
          echo "Example:  $ME  werner@utastro.uucp ./casetool"
          echo " "
          exit 0  ;;
    *   ) eval $ne"$AR" ; ne='FL=$FL" "' ;;
  esac
done
case $# in
  0 | 1 )
    echo " "
    echo "Usage:    $ME  [<options>] <mailpath> <file(s)>"
    echo "Example:  $ME  werner@utastro.uucp CaseTool"
    echo " "
    exit 0  ;;
esac
set $FL
TO=$1
case $SU in
  _default_ ) SU=$2 ;;
esac

case $DB in
  8|9) set -x ;;
esac

# create a copy of joinr in /tmp:
cat >$T4 <<'JOINR!END'
!NO!SUBS!
cat ./joinr >>$xfile
$spitshell >>$xfile <<'!NO!SUBS!'
JOINR!END

case $RA in               # hacked from usenet commentary; will
  all) ;;                 # be replaced by an awk script RSN
  *  )
    SIFS="$IFS"
    IFS=","
    for i in $RA ; do
      R=$R" "$i
    done
    RA=$R
    IFS=$SIFS
    R=""
    for tok in $RA ; do
      case $tok in 
      *-*)
        SIFS="$IFS"
        IFS='-'
        set $tok
        IFS="$SIFS"
        i=$1
        max=${2:-99}
        while test $i -le $max ; do
          R=$R" "$i
          i=`expr $i + 1`    # only exec in the entire parse
        done ;;
      *) R=$R" "$tok ;;
      esac
      RA=$R
    done ;;
esac

case $DB in
  5|6|7|8|9) echo "...beginning tar and compress..." ;;
esac
set $FL ; shift
for i in $* ; do
  if test -s $i ; then        # Test existence of each file to send
    FC=`expr $FC + 1`         # Increment file counter
  fi
done
if test $FC -gt 0 ; then      # Is there something to send?
  case $DB in                 # Yup. continue
    1|2|3|4) 
      case $TM in
        true )
          echo "would have issued command:"
          echo "$TA cvf $T1 $* 2> /dev/null"
	  case $CO in
	    *compress)
          	echo "CE=Z; $CO $CF $T1 1>/dev/null 2>&1 " ;;
	    *compact)
          	echo "CE=C; $CO $T1 1>/dev/null 2>&1 " ;;
	    *pack)
          	echo "CE=z; $CO $CF $T1 1>/dev/null 2>&1 " ;;
	    *cat)
          	echo "CE=tar; $MV $T1 $T1.$CE" ;;
	    *)
          	echo "$CO $T1 1>/dev/null 2>&1 " ;;
	  esac ;;
        false)  $TA cvf $T1 $* 2> /dev/null
	  	case $CO in
		    *compress)
        	  	CE=Z; $CO $CF $T1 1>/dev/null 2>&1 ;;
		    *compact)
        	  	CE=C; $CO $T1 1>/dev/null 2>&1 ;;
		    *pack)
        	  	CE=z; $CO $T1 1>/dev/null 2>&1 ;;
		    *cat)
	          	CE=tar; $MV $T1 $T1.$CE ;;
		    *)
	          	$CO $T1 1>/dev/null 2>&1 ;;
		 esac ;;
        *    ) echo "Sigh... Programmer error in $ME at line 93." ;;
      esac ;;
    *) 
      case $TM in
       true )
         echo "would have issued command:"
         echo "$TA cvf $T1 $* 2> /dev/null"
	 case $CO in
	   *compress)
         	echo "CE=Z; $CO $CF $T1 1>/dev/null 2>&1 " ;;
	   *compact)
         	echo "CE=C; $CO $T1 1>/dev/null 2>&1 " ;;
	   *pack)
         	echo "CE=z; $CO $T1 1>/dev/null 2>&1 " ;;
	    *cat)
          	echo "CE=tar; $MV $T1 $T1.$CE" ;;
	    *)
          	echo "$CO $T1 1>/dev/null 2>&1 " ;;
	 esac ;;
        false)  $TA cvf $T1 $* 2> /dev/null
	  	case $CO in
		    *compress)
        	  	CE=Z; $CO $CF $T1 1>/dev/null 2>&1 ;;
		    *compact)
        	  	CE=C; $CO $T1 1>/dev/null 2>&1 ;;
		    *pack)
        	  	CE=z; $CO $T1 1>/dev/null 2>&1 ;;
		    *cat)
	          	CE=tar; $MV $T1 $T1.$CE ;;
		    *)
	          	$CO $T1 1>/dev/null 2>&1 ;;
		 esac ;;
       *    ) echo "Sigh... Programmer error in $ME at line 153." ;;
      esac ;;
  esac
else                          # Nope, nothing to send
case $DB in
  [5-9] ) echo "...whoops!  Nothing to send!  Punting..." 1>&2 ;;
esac
  exit 1
fi
case $DB in
  5|6|7|8|9) echo "...finished tar, compress, starting uuencode..."
esac
case $TM in
  true )
    echo "would have issued command:"
    case $UU in
      uuencode|*uuencode)
	echo "$UU $T1.$CE `$BASENAME $T1.$CE` > $T2 " ;;
      *)	          
	echo "(cd $TD; $UU `$BASENAME $T1.$CE` > $T2) " ;;
    esac ;;
  false) 
    case $UU in
      uuencode|*uuencode) 
	$UU $T1.$CE `$BASENAME $T1.$CE` > $T2 ;;
      *)
	(cd $TD; $UU `$BASENAME $T1.$CE` > $T2) ;;
    esac ;;
  *    ) echo "Sigh... Programmer error in $ME at line 170." ;;
esac
case $DB in
  5|6|7|8|9) echo "...finished uuencode, starting split..." ;;
esac
case $TM in 
  true )
    echo "would have issued command:" 
    echo "$SPLIT -$LI $T2 $T3" ;; 
  false)  $SPLIT -$LI $T2 $T3 ; ;; 
  *    ) echo "Sigh... Programmer error in $ME at line 128." ;;
esac 
case $TM in
  true )
    echo "would have issued commands:"
    case $MS in
      archive) echo "$CAT > $TO"_n ;;
      Subj)    echo "$MA -s "$SU - part n of m" $TO" ;;
    esac
    echo "with n ranging from 1 to m; m cannot be determined."
    echo "without running for real."
    exit 0 ;;
esac 

n=1
set $T3*
for f  do
  SE=false
  case $RA in
    all)  SE=true ;;
    *  )
      for p in $RA ; do
        case $p in
          $n ) SE=true ;;
        esac
      done ;;
  esac
  case $SE in
    true)
    {
    echo " "
    case $n in
    1)
      if test ! -s $f ; then
        case $DB in 
          [5-9]) echo "...whoops!  $SPLIT failed!   Punting..." 1>&2 ;;
        esac 
        exit 1 ;
      fi
      case $IJ in
        true) cat $T4 ;;
      esac
      echo " " ;;
    esac
    echo " "
    echo "This file was packed by mailsplit version:"
    echo $VE
    echo with command:
    echo "$CM"
    echo "on: `date`"
    echo " "
    echo "--- start of $SU part $n of $#"
    $CAT $f
    echo "--- end of $SU part $n of $#"
    echo " "
    echo " "
    } | 
    case $MS in
      Subj)    $MA $MF -s "$SU - part $n of $#" $TO ;;
      archive) $CAT > $TO$SPRT$n ;;
      *)       $MA $MF $TO ;;
    esac
    case $MS in
      archive) echo "...output into $TO$SPRT$n..." ;;
      *) case $DB in
	   [5-9]) echo "...sent part $n of $# to $MA..."
	    	  echo "...sleeping $DE seconds (waiting for mailer) ..." ;;
	 esac
	 sleep $DE ;;
    esac
  esac
  n=`expr $n + 1`
  if test `expr $n % 10` -eq 0;  then
      SPRT=$SPRT"_"
  fi
done
$RM -f $T1.$CE $T2 $T3* $T4
!NO!SUBS!
chmod 755 $xfile
$eunicefix $xfile
