/* Written by Stephen J. Muir, Computing Dept., Lancaster University */

# include <sys/types.h>
# include <sys/stat.h>
# include <sys/file.h>
# include <stdio.h>

extern char	*malloc ();

char	*mailer = "/usr/lib/sendmail", **newargv, **nargvp;

int	fd, count;

struct stat	stat;

main (argc, argv, envp)
	char	*argv [], *envp [];
	{ register char	*cp, *recipients;
	  if (argc != 2)
	  { fprintf (stderr, "usage: maillistfile file\n");
	    exit (1);
	  }
	  if ((fd = open (argv [1], O_RDONLY, 0)) == -1)
	  { perror (argv [1]);
	    exit (1);
	  }
	  setuid (getuid ());
	  (void)fstat (fd, &stat);
	  if ((stat.st_mode & S_IFMT) != S_IFREG)
	  { fprintf (stderr, "%s: not a regular file", argv [1]);
	    exit (1);
	  }
	  if ((recipients = malloc (stat.st_size)) == 0)
	  { fprintf (stderr, "Out of memory.\n");
	    exit (1);
	  }
	  if (read (fd, recipients, stat.st_size) != stat.st_size)
	  { perror ("read()");
	    exit (1);
	  }
	  for (cp = recipients; cp < recipients + stat.st_size; ++cp)
		if (*cp == '\0')
		{ fprintf (stderr, "%s: null byte in file\n", argv [1]);
		  exit (1);
		}
		else if (*cp == '\n')
		{ *cp = '\0';
		  ++count;
		}
	  if (*--cp != '\0')
	  { fprintf (stderr, "%s: incomplete last line\n", argv [1]);
	    exit (1);
	  }
	  if (count == 0)
	  { fprintf (stderr, "%s: empty list\n", argv [1]);
	    exit (1);
	  }
	  if ((nargvp =
	       newargv =
	       (char **)malloc ((sizeof (char **)) * (count + 3))
	      ) == 0
	     )
	  { fprintf (stderr, "Out of memory.\n");
	    exit (1);
	  }
	  *nargvp++ = "maillist";
	  *nargvp++ = "-oMslist-channel";
	  cp = recipients;
	  while (count--)
	  { *nargvp++ = cp;
	    while (*cp++ != '\0');
	  }
	  *nargvp++ = 0;
	  execve (mailer, newargv, envp);
	  perror (mailer);
	  exit (1);
	}
