/*
 * $Source: /usr/src/local/local.bin/ease/src/RCS/fixstrings.c,v $
 * $Locker:  $
 *
 * $Revision: 2.0 $
 * Check-in $Date: 88/06/15 14:41:19 $
 * $State: Exp $
 *
 * $Author: root $
 *
 * $Log:	fixstrings.c,v $
 * Revision 2.0  88/06/15  14:41:19  root
 * Baseline release for net posting. ADR.
 * 
 * Version 1.3  87/03/05  19:38:33  jeff
 * Edited RCS header and FLUKEid[] string.
 * 
 * Version 1.2  87/02/25  16:55:13  jeff
 * Add some RCS header lines.  No code changes.
 * 
 */

/*  FLUKE jps 16-apr-86 - special hacks for NULL pointers.
 *
 *  The author of ease used a *lot* of NULL pointers.  This isn't much
 *  of a problem on a vax, where NULL pointers look like "".  Not so on a Sun.
 *
 *  We hack around the problem by defining a set of wrappers for the
 *  standard string functions, making it appear as though they accept NULL
 *  pointers.  In the other C files, cpp macros are used to revector the
 *  standard string functions to this file.
 */
#include <strings.h>
#define fix(s) ((s) ? (s) : "")

char *Xstrcat (s1, s2)
char *s1, *s2; 
{
	return (strcat (s1, fix (s2)));
}

char *Xstrncat (s1, s2, n)
char *s1, *s2; 
{
	return (strncat (s1, fix (s2), n));
}

Xstrcmp (s1, s2)
char *s1, *s2; 
{
	return (strcmp (fix (s1), fix (s2)));
}

Xstrncmp (s1, s2, n)
char *s1, *s2; 
{
	return (strncmp (fix (s1), fix (s2), n));
}

char *Xstrcpy (s1, s2)
char *s1, *s2; 
{
	return (strcpy (s1, fix (s2)));
}

char *Xstrncpy (s1, s2, n)
char *s1, *s2; 
{
	return (strncpy (s1, fix (s2), n));
}

Xstrlen (s)
char *s; 
{
	return (strlen (fix (s)));
}

char *Xindex (s, c)
char *s, c; 
{
	return (index (fix (s), c));
}

char *Xrindex (s, c)
char *s, c; 
{
	return (rindex (fix (s), c));
}
