#! /bin/ksh

# ease -- run /lib/cpp and send the output into the ease translator
#
# usage: ease [ cpp options ] [ input files ] [ -o output_file ]

PATH=/bin:/usr/ucb:/usr/bin
export PATH

function usage
{
	echo usage: ease [ cpp options ] [ input files ] [ -o output_file ] 1>&2
	exit 1
}

ifiles=
ofile=
opts=

while [ $# -gt 0 ]
do
	case "$1" in
	-o)	if [ "$2" ]
		then
			ofile="$2"
			shift
		else
			usage
		fi
		;;
	-o?*)	ofile="${1#-o}" ;;
	-?*)	opts="$opts $1" ;;	# probably -D or -I cpp options
	*)	ifiles="$ifiles $1" ;;	# will catch plain "-"
	esac
	shift
done

# use cat, since it understands the "-" convention

cat $ifiles | /lib/cpp $opts | cat -s | /usr/local/lib/et - $ofile
