/*************************************************************
  miscellaneous routines
 *************************************************************/

#include <stdio.h>
#include <sys/time.h>

/* returns a newly allocated copy of a string */
char *copystr(str)
	  char *str;
{
  char *tmp, *calloc();
  if (!str)
    return NULL;
  tmp = calloc(strlen(str)+1, 1);
  strcpy(tmp, str);
  return tmp;
}

/* figure out correct time and timezone */
char *mailtime() {
  long my_time;
  char *atime;
  static char buf[32];
  struct timeval tv;
  struct timezone tzp;
  my_time = time(0L);
  atime = asctime(localtime(&my_time));
  atime[strlen(atime)-1] = '\0';	/* zap "\n" */
  gettimeofday(&tv, &tzp);
  sprintf(buf, "%s %s", atime, timezone(tzp.tz_minuteswest, tzp.tz_dsttime));
  return buf;
}
