/* $Header: uucp.c,v 2.1 89/06/09 12:25:44 network Exp $
 *
 * Handle mail destined for other hosts via UUCP.
 * Deliver is intended as a very low-level program, so we don't
 * do anything fancy here.  We just hand the message to uux.
 *
 * $Log:	uucp.c,v $
 * Revision 2.1  89/06/09  12:25:44  network
 * Update RCS revisions.
 * 
 * Revision 1.5  89/06/09  12:24:02  network
 * Baseline for 2.0 release.
 * 
 */

#include "deliver.h"
#include <sys/stat.h>

/*
 * Local functions.
 */

static  int     uucp_copy();

/*----------------------------------------------------------------------
 * Send mail to UUCP addresses (if any).
 * This is a simple implementation: invoke uux once per address.
 */

uucp_deliver()
{
	struct stat st;
	DEST    *d;
	char    *uux;
	static char uux1[] = "/bin/uux";
	static char uux2[] = "/usr/bin/uux";

	if (stat(uux1, &st) == 0)
		uux = uux1;
	else if (stat(uux2, &st) == 0)
		uux = uux2;
	else
	{
		error("can't find uux!?\n");
		return;
	}

	for (d = first_dest(); d; d = next_dest(d))
	{
		FILE    *uux_fp;
		char    *bang;
		char    *av[5];
		char    rmail[40];
		char    who[BUFSIZ];

		if (d->d_class != CL_UUCP || d->d_state != ST_WORKING)
			continue;

		if (printaddrs)
			(void) printf("%s\n", d->d_name);

		if (dryrun)
		{
			d->d_state = ST_DONE;
			continue;
		}

		bang = strchr(d->d_name, '!');
		*bang = 0;
		(void) sprintf(rmail, "%s!rmail", d->d_name);
		*bang++ = '!';
		(void) sprintf(who, "(%s)", bang);

		av[0] = "uux";
		av[1] = "-";
		av[2] = rmail;
		av[3] = who;
		av[4] = NULL;
		if ((uux_fp = ct_popenv(eff_ct, uux, av, "w")) == NULL)
			continue;

		if (uucp_copy(uux_fp) < 0)
			dest_err(d, E_UUX);

		if (ct_pclose(uux_fp))
		{
			/* "No such host" overrides piping problems. */
			dest_err(d, E_NSHOST);
		}
		else
			d->d_state = ST_DONE;
	}
}

/*----------------------------------------------------------------------
 * Write the message for UUCP transmission to the given file.
 */

static int
uucp_copy(ofp)
FILE    *ofp;
{
	FILE    *ifp;
	char    *p;
	register int c;
	int     fd;
	char    buf[BUFSIZ];

	if ((fd = dup(tfd[T_HDR])) == -1)
	{
		syserr("can't dup header fd");
		return -1;
	}
	(void) lseek(fd, 0L, 0);
	if ((ifp = fdopen(fd, "r")) == NULL)
	{
		error("can't fdopen header fd");
		return -1;
	}

	/*
	 * Copy the header, but tack "remote from" onto the end of the
	 * From_ line.  (If it weren't for dealing with the From_ line,
	 * I'd skip stream I/O altogether and use read/write.  Maybe
	 * I should save the length of the From_ line when I copy it...)
	 */

	(void) fgets(buf, GETSIZE(buf), ifp);
	if ((p = strchr(buf, '\n')) != NULL)
		*p = 0;
	(void) fprintf(ofp, "%s remote from %s\n", buf, hostname);

	while ((c = getc(ifp)) != EOF)
		(void) putc(c, ofp);

	(void) fclose(ifp);

	/*
	 * Copy the body
	 */

	if ((fd = dup(tfd[T_BODY])) == -1)
	{
		syserr("can't dup body fd");
		return -1;
	}
	(void) lseek(fd, 0L, 0);
	if ((ifp = fdopen(fd, "r")) == NULL)
	{
		error("can't fdopen body fd");
		(void) close(fd);
		return -1;
	}

	while ((c = getc(ifp)) != EOF)
		(void) putc(c, ofp);

	(void) fclose(ifp);
	return 0;
}
