/* $Header: sysdep.c,v 2.1 89/06/09 12:25:40 network Exp $
 *
 * Routines which are (or might well be) system-dependant.
 * I've put the message routines here since you may need to use
 * the ANSI <stdarg.h> instead of <varargs.h>.
 *
 * $Log:	sysdep.c,v $
 * Revision 2.1  89/06/09  12:25:40  network
 * Update RCS revisions.
 * 
 * Revision 1.8  89/06/09  12:23:59  network
 * Baseline for 2.0 release.
 * 
 */

#include "deliver.h"
#include <errno.h>
#ifdef HAS_STDARG
#include <stdarg.h>
#else
#ifdef HAS_VARARGS
#include <varargs.h>
#else
/*
 * Non-portable home-grown varargs.  Use at your own risk.
 * Especially note that if sizeof(int) > sizeof(short), then
 * "va_arg(..,short)" is broken.
 */
typedef char *va_list;
#define va_dcl          int va_alist;
#define va_start(ap)    ap = (char *) &va_alist
#define va_arg(ap,type) *(type *)(ap += sizeof(type), ap - sizeof(type))
#define va_end(ap)      /* nothing */
#endif
#endif

#ifdef UNAME
#include <sys/utsname.h>
#endif

/*
 * External functions.
 */

#ifdef M_XENIX
extern  long    nap();
#else
extern  unsigned sleep();
#endif

/*
 * External data.
 */

extern  int     errno;
extern  int     sys_nerr;
extern  char    *sys_errlist[];

/*----------------------------------------------------------------------
 * Print a message.
 */

/* VARARGS */
#ifdef HAS_STDARG
message(char *fmt, ...)
#else
message(va_alist) va_dcl
#endif
{
	va_list ap;

#ifdef HAS_STDARG
	va_start(ap, fmt);
#else
	char    *fmt;
	va_start(ap);
	fmt = va_arg(ap, char *);
#endif

	(void) vfprintf(stderr, fmt, ap);

	va_end(ap);
}

/*----------------------------------------------------------------------
 * Print an error message.
 */

/* VARARGS */
#ifdef HAS_STDARG
error(char *fmt, ...)
#else
error(va_alist) va_dcl
#endif
{
	va_list ap;

#ifdef HAS_STDARG
	va_start(ap, fmt);
#else
	char    *fmt;
	va_start(ap);
	fmt = va_arg(ap, char *);
#endif

	(void) fprintf(stderr, "%s: ", progname);
	(void) vfprintf(stderr, fmt, ap);

	va_end(ap);
}

/*----------------------------------------------------------------------
 * Report an error returned from a system call.
 */

/* VARARGS */
#ifdef HAS_STDARG
syserr(char *fmt, ...)
#else
syserr(va_alist) va_dcl
#endif
{
	int     e = errno;
	va_list ap;

#ifdef HAS_STDARG
	va_start(ap, fmt);
#else
	char    *fmt;
	va_start(ap);
	fmt = va_arg(ap, char *);
#endif

	(void) fprintf(stderr, "%s: ", progname);
	(void) vfprintf(stderr, fmt, ap);
	if (e <= sys_nerr)
		(void) fprintf(stderr, ": %s\n", sys_errlist[e]);
	else
		(void) fprintf(stderr, ": unknown system error %d\n", e);

	va_end(ap);
}

/*----------------------------------------------------------------------
 * Sleep for the given number of seconds.
 */

snooze(n)
int     n;
{
#ifdef M_XENIX
	(void) nap(n * 1000L);
#else
	(void) sleep(n);
#endif
}

/*----------------------------------------------------------------------
 * Get the host name from HOSTFILE.
 */

#ifdef HOSTFILE

char *
gethost()
{
	int     fd, rd;
	char    *p;
	static char name[32];

	if ((fd = open(HOSTFILE, O_RDONLY)) == -1)
		return NULL;
	rd = read(fd, name, sizeof(name) - 1);
	(void) close(fd);

	if (rd < 1)
		return NULL;
	name[rd] = 0;
	if ((p = strchr(name, '\n')) != NULL)
		*p = 0;

	return (name[0] ? name : NULL);
}

#endif /* HOSTFILE */

/*----------------------------------------------------------------------
 * Get the host name via the uname() system call.
 */

#ifdef UNAME

char *
gethost()
{
	static struct utsname u;

	uname(&u);
	return (u.nodename[0] ? u.nodename : NULL);
}

#endif /* UNAME */

/*----------------------------------------------------------------------
 * Get the host name via the gethostname() system call.
 */

#ifdef GETHOSTNAME

char *
gethost()
{
	static char hostname[64];

	if (gethostname(hostname, sizeof(hostname)) == -1)
		return NULL;

	return hostname;
}

#endif /* GETHOSTNAME */

/*----------------------------------------------------------------------
 * Return a pre-defined HOSTNAME.
 */

#ifdef HOSTNAME

char *
gethost()
{
	return HOSTNAME;
}

#endif /* HOSTNAME */

/*----------------------------------------------------------------------
 * Variable-argument-list output, System V style.
 */

#ifndef HAS_VPRINTF

vprintf(fmt, ap)
char    *fmt;
va_list ap;
{
	int     a,b,c,d,e,f,g,h;

	a = va_arg(ap, int);
	b = va_arg(ap, int);
	c = va_arg(ap, int);
	d = va_arg(ap, int);
	e = va_arg(ap, int);
	f = va_arg(ap, int);
	g = va_arg(ap, int);
	h = va_arg(ap, int);

	(void) printf(fmt, a,b,c,d,e,f,g,h);
}

vfprintf(fp, fmt, ap)
FILE    *fp;
char    *fmt;
va_list ap;
{
	int     a,b,c,d,e,f,g,h;

	a = va_arg(ap, int);
	b = va_arg(ap, int);
	c = va_arg(ap, int);
	d = va_arg(ap, int);
	e = va_arg(ap, int);
	f = va_arg(ap, int);
	g = va_arg(ap, int);
	h = va_arg(ap, int);

	(void) fprintf(fp, fmt, a,b,c,d,e,f,g,h);
}

vsprintf(s, fmt, ap)
char    *s;
char    *fmt;
va_list ap;
{
	int     a,b,c,d,e,f,g,h;

	a = va_arg(ap, int);
	b = va_arg(ap, int);
	c = va_arg(ap, int);
	d = va_arg(ap, int);
	e = va_arg(ap, int);
	f = va_arg(ap, int);
	g = va_arg(ap, int);
	h = va_arg(ap, int);

	(void) sprintf(s, fmt, a,b,c,d,e,f,g,h);
}

#endif  /* !HAS_VPRINTF */

/*----------------------------------------------------------------------
 * Add a new environment variable.
 */

#ifndef HAS_PUTENV

int
putenv(s)
char *s;
{
	static  char    **env_array;
	static  int     env_size;
	char    *e;
	int     i, j;

	if (env_array == NULL)
	{
		for (i = 0; environ[i]; ++i)
			{}
		env_size = i + 10;      /* arbitrary */
		env_array = (char **) zalloc(env_size * sizeof(char *));
		Copy((char *)env_array, (char *)environ,
		     (int) ((i + 1) * sizeof(char *)));
		environ = env_array;
	}
	else if (environ != env_array)
		message("putenv: warning: someone moved environ!\n");

	if ((e = strchr(s, '=')) != NULL)
		++e;
	else
		e = s + strlen(s);

	j = 0;
	for (i = 0; env_array[i]; ++i)
	{
		if (strncmp(env_array[i], s, e - s) != 0)
			env_array[j++] = env_array[i];
	}

	if ((j + 1) >= env_size)
	{
		env_size += 10;                 /* arbitrary */
		env_array = (char **) srealloc((char *)env_array,
					env_size * sizeof(char **));
	}

	env_array[j++] = s;
	env_array[j] = NULL;

	environ = env_array;
	return 0;
}

#endif  /* !HAS_PUTENV */

/*----------------------------------------------------------------------
 * Memory copy.
 */

#ifdef MEMFUNCS

Copy(dest, src, len)
char    *dest;
char    *src;
int     len;
{
	while (len-- > 0)
		*dest++ = *src++;
}

#endif

/*----------------------------------------------------------------------
 * Memory clear.
 */

#ifdef MEMFUNCS

Zero(dest, len)
char    *dest;
int     len;
{
	while (len-- > 0)
		*dest++ = 0;
}

#endif
