/* $Header: misc.h,v 2.1 89/06/09 12:25:35 network Exp $
 *
 * Miscellaneous definitions.
 *
 * $Log:	misc.h,v $
 * Revision 2.1  89/06/09  12:25:35  network
 * Update RCS revisions.
 * 
 * Revision 1.7  89/06/09  12:23:56  network
 * Baseline for 2.0 release.
 * 
 */

/*
 * Non-portable include files
 */

#ifdef USG
#include <fcntl.h>
#include <string.h>
#include <memory.h>
#endif

#ifdef BSD
#include <strings.h>
#include <sys/file.h>
#endif

/*
 * Constants
 */

#ifdef NULL
#undef NULL
#endif
#define NULL    0               /* The One True NULL */

#define FALSE   0
#define TRUE    1

#ifndef O_RDONLY
#define O_RDONLY   0
#define O_WRONLY   1
#define O_RDWR     2
#endif

/*
 * Macros.
 */

/* Length parameter for fgets() on given buffer. */

#define GETSIZE(buf)    (int) (sizeof(buf) - 1)

/*
 * Public data.
 */

extern  char    **environ;

/*
 * Common library functions.
 */

extern  char    *ctime();
extern  char    *getenv();
extern  char    *malloc();
extern  char    *realloc();
extern  char    *mktemp();
extern  int     putenv();
extern  long    lseek();
extern  long    time();
extern  void    free();

#ifdef DECLARE_SIGNAL
extern  SIGTYPE (*signal())();
#endif

/*
 * String search functions.
 */

#ifndef USG

#ifndef BSD
extern  char    *index();
extern  char    *rindex();
#endif /* not BSD */

#define strchr          index
#define strrchr         rindex

#endif

/*
 * Memory copy and zero.
 */

#ifdef USG
#define Copy(d,s,n)     (void) memcpy(d,s,n)
#define Zero(d,n)       (void) memset(d,0,(int)(n))
#else /* not USG */
#ifdef BSD
#define Copy(d,s,n)     bcopy(s,d,n)
#define Zero(d,n)       bzero(d,n)
#else /* not BSD */
#define MEMFUNCS        /* define Copy() and Zero() in sysdep.c */
#endif /* not BSD */
#endif /* not USG */

/*
 * Line-buffering on stdio files.
 */

#ifdef USG

extern  int     setvbuf();

#ifdef REVERSE_SETVBUF
#define Linebuf(f)      (void) setvbuf(f, _IOLBF, (char *)NULL, BUFSIZ)
#else
#define Linebuf(f)      (void) setvbuf(f, (char *)NULL, _IOLBF, BUFSIZ)
#endif

#else /* not USG */
#ifdef BSD

extern  int     setlinebuf();

#define Linebuf(f)      (void) setlinebuf(f)

#else /* not BSD */

#define Linebuf(f)      /* can't do it */

#endif /* not BSD */
#endif /* not USG */
