/* $Header: dest.h,v 2.1 89/06/09 12:25:23 network Exp $
 *
 * Description of a mail destination and its state.
 *
 * $Log:	dest.h,v $
 * Revision 2.1  89/06/09  12:25:23  network
 * Update RCS revisions.
 * 
 * Revision 1.3  89/06/09  12:23:48  network
 * Baseline for 2.0 release.
 * 
 */

/*----------------------------------------------------------------------
 * Destination class.
 */

typedef enum {
	CL_USER,                /* User name, no mailbox                */
	CL_MBOX,                /* User name, with mailbox name         */
	CL_UUCP                 /* UUCP address (bang path)             */
} DCLASS;

/*----------------------------------------------------------------------
 * Destination state.
 */

typedef enum {
	ST_WORKING,             /* the "normal" state                   */
	ST_HOLD,                /* on hold during expansion             */
	ST_DONE,                /* all processing complete              */
	ST_ERROR                /* "something is horribly wrong"        */
} DSTATE;

/*----------------------------------------------------------------------
 * Types of destination errors.
 */

typedef enum {
	E_IVADDR,               /* invalid address string               */
	E_NSUSER,               /* no such user                         */
	E_NSHOST,               /* no such host (UUCP addresses)        */
	E_CTPERM,               /* no permissions for that context      */
	E_CTLOST,               /* context lost (should never happen)   */
	E_MBOX,                 /* can't write to mailbox               */
	E_UUX                   /* can't pipe to uux                    */
} DERROR;

/*----------------------------------------------------------------------
 * Structure describing a mail destination.
 */

#define DEST    struct dest
DEST {
	DEST    *d_next;        /* next destination in the chain        */
	DEST    *d_prev;        /* previous destination in the chain    */
	DCLASS  d_class;        /* destination class                    */
	DSTATE  d_state;        /* destination state                    */
	DERROR  d_error;        /* error message (if state is ERROR)    */
	int     d_dfdone;       /* boolean -- delivery file was run     */
	char    *d_name;        /* context for delivery                 */
	char    *d_mailbox;     /* mailbox name or NULL for default     */
};

/*----------------------------------------------------------------------
 * Action macros.
 */

#define dest_err(d,m)   ((d)->d_state = ST_ERROR, (d)->d_error = (m))
