/* $Header: dest.c,v 2.1 89/06/09 12:25:22 network Exp $
 *
 * Operations on the list of mail destinations.
 *
 * $Log:	dest.c,v $
 * Revision 2.1  89/06/09  12:25:22  network
 * Update RCS revisions.
 * 
 * Revision 1.5  89/06/09  12:23:45  network
 * Baseline for 2.0 release.
 * 
 */

#include "deliver.h"

/*
 * Local data.
 */

static  DEST    deadhead = { &deadhead, &deadhead };
#define HEADPTR	(&deadhead)

/*----------------------------------------------------------------------
 * Add a new destination to the list (unless it already exists).
 * Return pointer to DEST.
 */

DEST *
dest(name, mailbox)
char    *name;
char    *mailbox;
{
	DEST    *d;
	DCLASS   class;

	if (strchr(name, '!'))
		class = CL_UUCP;
	else if (mailbox)
		class = CL_MBOX;
	else
		class = CL_USER;

	for (d = HEADPTR->d_next; d != HEADPTR; d = d->d_next)
	{
		if (d->d_class != class)
			continue;

		if (strcmp(d->d_name, name) != 0)
			continue;

		/*
		 * If this destination has a named mailbox, then
		 * test it for equality as well.
		 */

		if (class == CL_MBOX
		 && strcmp(d->d_mailbox, mailbox) != 0)
			continue;

		/*
		 * Like, gnarly, dude!  It's already in the chain!
		 */

		return d;
	}

	/*
	 * The given dest isn't in the list, so we have to add it.
	 */

	d = (DEST *) zalloc(sizeof(DEST));
	d->d_class = class;
	d->d_state = ST_WORKING;
	d->d_name = copystr(name);
	if (class == CL_MBOX)
		d->d_mailbox = copystr(mailbox);

	/*
	 * Check address for validity.
	 */

	if (!valid_address(name))
		dest_err(d, E_IVADDR);
	else if (class != CL_UUCP && name_context(name) == NULL)
		dest_err(d, E_NSUSER);

	/*
	 * Put new address at the end of of the chain.
	 * (This is important!  Other code depends on it.)
	 */

	d->d_prev = HEADPTR->d_prev;
	d->d_next = HEADPTR;
	d->d_prev->d_next = d;
	d->d_next->d_prev = d;

	return d;
}

/*----------------------------------------------------------------------
 * Return pointer to first DEST in the list.
 */

DEST *
first_dest()
{
	if (HEADPTR->d_next != HEADPTR)
		return HEADPTR->d_next;

	return NULL;
}

/*----------------------------------------------------------------------
 * Return pointer to next DEST in the list, or NULL.
 */

DEST *
next_dest(d)
DEST    *d;
{
	if (d && (d = d->d_next) != HEADPTR)
		return d;

	return NULL;
}

/*----------------------------------------------------------------------
 * Return an error message given a DERROR.
 */

char *
derrmsg(e)
DERROR  e;
{
	static  char    unknown_buf[40];

	switch (e)
	{
	case E_IVADDR:
		return "Invalid address string";
	case E_NSUSER:
		return "No such user";
	case E_NSHOST:
		return "No such host (UUCP addresses)";
	case E_CTPERM:
		return "No permissions for that context";
	case E_CTLOST:
		return "Context lost (should never happen)";
	case E_MBOX:
		return "Can't write to mailbox";
	case E_UUX:
		return "Can't pipe to uux";
	}

	(void) sprintf(unknown_buf, "Unknown error %d", e);
	return unknown_buf;
}
