/* $Header: debug.c,v 2.1 89/06/09 12:25:17 network Exp $
 *
 * Debugging output.
 *
 * $Log:	debug.c,v $
 * Revision 2.1  89/06/09  12:25:17  network
 * Update RCS revisions.
 * 
 * Revision 1.4  89/06/09  12:23:42  network
 * Baseline for 2.0 release.
 * 
 */

#include "deliver.h"

/*----------------------------------------------------------------------
 * Print out a complete dump of all destinations
 */

dumpdests(when)
char    *when;
{
	DEST    *d;

	message("Destinations %s:\n", when);
	for (d = first_dest(); d; d = next_dest(d))
	{
		message("\t%s", d->d_name);

		switch (d->d_class)
		{
		case CL_USER:
			/* it's understood */
			break;
		case CL_MBOX:
			message(", mailbox='%s'", d->d_mailbox);
			break;
		case CL_UUCP:
			message(" (UUCP)");
			break;
		}
		message("; ");
		switch (d->d_state)
		{
		case ST_WORKING:
			message("Working");
			break;
		case ST_HOLD:
			message("Hold");
			break;
		case ST_DONE:
			message("Done");
			break;
		case ST_ERROR:
			message("Error (%s)", derrmsg(d->d_error));
			break;
		}
		message("\n");
	}
}
