/* $Header: config.h,v 2.2 89/06/09 13:07:38 network Exp $
 *
 * Deliver configuration.
 *
 * $Log:	config.h,v $
 * Revision 2.2  89/06/09  13:07:38  network
 * Adapt to BSD quirks.
 * 
 * Revision 2.1  89/06/09  12:25:11  network
 * Update RCS revisions.
 * 
 * Revision 1.11  89/06/09  12:23:38  network
 * Baseline for 2.0 release.
 * 
 */

/*----------------------------------------------------------------------
 * SCO Xenix System V compilers define M_SYSV, which implies USG.
 */

#ifdef M_SYSV
#ifndef USG
#define USG
#endif
#endif

/*----------------------------------------------------------------------
 * Trusted users.
 * Deliver permits "trusted" users to specify delivery filenames
 * without renouncing setuid privileges.  Essentially, these users
 * are given the root password.  Beware!
 */

#define TRUSTED_USERS   "root", "uucp"

/*----------------------------------------------------------------------
 * Signal function type.
 * Signal catching routines have this return value.
 * (For System V Release 3.0 or later, use "void".)
 */

#ifdef USG
# define SIGTYPE void
#else
# define SIGTYPE int
#endif

/*----------------------------------------------------------------------
 * Signal function declaration.
 * Define this if your <signal.h> doesn't declare signal() correctly.
 */

/* #define DECLARE_SIGNAL */

/*----------------------------------------------------------------------
 * Signal flag type.
 * Variables of this type may be set by signal catching routines.
 */

#ifdef __STDC__
#define SIGFLAG sig_atomic_t
#else
#define SIGFLAG short   /* or "volatile short" for aggressive optimizers */
#endif

/*----------------------------------------------------------------------
 * Various kinds of mailbox locking.
 * You may define one or both of ML_DOTLOCK and ML_DOTMLK.
 * You may define no more than one of ML_FCNTL, ML_LOCKF and ML_LOCKING.
 *
 * File creation locking:
 *     ML_DOTLOCK   create <mailbox>.lock       (most systems except BSD4.3)
 *     ML_DOTMLK    create /tmp/<basename>.mlk  (Xenix)
 *
 * Kernel record locking:
 *     ML_FCNTL     lock with fcntl(F_SETLKW)   (SVID systems only)
 *     ML_LOCKF     lock with lockf(F_LOCK)     (SVID systems only)
 *     ML_LOCKING   lock with locking(LK_LOCK)  (Xenix systems only)
 */

#ifdef M_XENIX
#define ML_DOTMLK
#define ML_LOCKING
#else
#define ML_DOTLOCK
#endif

/*----------------------------------------------------------------------
 * Maximum filename length.
 * Note that this is for _filenames_, not _pathnames_.
 * For AT&T file systems, the usual value is 14.
 * For Berzerkley file systems, use something big like 255.
 */

#ifdef BSD
#define MAX_NAMESIZE    255
#else
#define MAX_NAMESIZE    14
#endif

/*----------------------------------------------------------------------
 * How to get the host name.
 * Define one.
 *
 * HOSTFILE             file containing name    (Xenix)
 * UNAME                uname()                 (System V)
 * GETHOSTNAME          gethostname()           (BSD)
 * HOSTNAME             host name string        (V7)
 */

#ifdef M_XENIX
#define HOSTFILE   "/etc/systemid"
#else
#ifdef USG
#define UNAME
#else
#ifdef BSD
#define GETHOSTNAME
#else
#define HOSTNAME   "cleese"
#endif
#endif
#endif

/*----------------------------------------------------------------------
 * Is <varargs.h> or <stdarg.h> available?
 */

#ifdef __STDC__
#define HAS_STDARG
#else
#ifdef USG
#define HAS_VARARGS
#else
#ifdef BSD
#define HAS_VARARGS
#endif
#endif
#endif

/*----------------------------------------------------------------------
 * Are vprintf() and friends available?
 */

#ifdef USG
#define HAS_VPRINTF
#endif

/*----------------------------------------------------------------------
 * Is putenv() available?
 */

#ifdef USG
#define HAS_PUTENV
#endif

/*----------------------------------------------------------------------
 * Is getopt() available?
 */

#ifdef USG
#define HAS_GETOPT
#endif

/*----------------------------------------------------------------------
 * Is setvbuf() backwards?
 * Note: this is true for SCO Xenix Development System 2.2.
 */

/* #define REVERSE_SETVBUF */

/*----------------------------------------------------------------------
 * Name of shell used to execute delivery files.
 */

#define SHELL   "/bin/sh"

/*----------------------------------------------------------------------
 * Characters that may not appear in addresses.
 * (This string should include all metacharacters for your chosen shell.)
 */

#define SANITIZE   "$*?=\\`'\"|^&;{}()<> \t\n"

/*----------------------------------------------------------------------
 * Standard mailbox location.
 *
 * Define either MBX_NAME or MBOX_DIR.
 * If MBX_NAME is defined, then the default mailbox is a file with
 * that name in the user's home directory.
 * If MBX_DIR is defined, then the default mailbox is a file in that
 * directory with the same name as the user.
 *
 * Define MBX_GROUP if all mailboxes must be owned by a specific group.
 * (System V requires this feature.)  If MBX_GROUP is not defined,
 * mailboxes will have their groups set to the recipients' default group.
 *
 * Define MBX_MODE to the file access modes for new mailboxes.
 * (System V requires group write permissions, i.e. 0020.)
 */

#if defined(USG) && !defined(M_XENIX)
/* #define MBX_NAME   "mbox" */
#define MBX_DIR     "/usr/mail"
#define MBX_MODE    0660
#define MBX_GROUP   "mail"
#else
/* #define MBX_NAME   "mbox" */
#define MBX_DIR     "/usr/spool/mail"
#define MBX_MODE    0600
#endif

/*----------------------------------------------------------------------
 * Names of delivery files.
 *
 * SYS_DELIVER          system-wide delivery file
 * POST_DELIVER         post-user delivery file
 * USER_DELIVER         user delivery file (in user's home directory)
 */

#define SYS_DELIVER     "/usr/local/lib/deliver.sys"
#define POST_DELIVER    "/usr/local/lib/deliver.post"
#define USER_DELIVER    ".deliver"

/*----------------------------------------------------------------------
 * Environment variables passed to child processes.
 */

#define ENV_DFLAGS      "DELFLAGS"      /* Flags: [-[Avdt]]             */
#define ENV_SYSDEL      "SYSDELFILE"    /* System delivery file         */
#define ENV_POSTDEL     "POSTDELFILE"   /* Post-user delivery file      */
#define ENV_USERDEL     "USERDELFILE"   /* User delivery file           */

#define ENV_HOSTNAME    "HOSTNAME"      /* Name of this host            */
#define ENV_SENDER      "SENDER"        /* Message sender               */
#define ENV_HEADER      "HEADER"        /* Message header file          */
#define ENV_BODY        "BODY"          /* Message body file            */
