/* $Header: subs.c,v 2.1 89/06/09 12:25:39 network Exp $
 *
 * Miscellaneous subroutines.
 *
 * $Log:	subs.c,v $
 * Revision 2.1  89/06/09  12:25:39  network
 * Update RCS revisions.
 * 
 * Revision 1.8  89/06/09  12:23:58  network
 * Baseline for 2.0 release.
 * 
 */

#include "deliver.h"

/*----------------------------------------------------------------------
 * Allocate memory for an environment variable, and putenv() it.
 */

alloc_env(name, value)
char    *name;
char    *value;
{
	char    *s;

	if (!name || !value)
		return;

	s = zalloc((unsigned) (strlen(name) + strlen(value) + 2));
	(void) sprintf(s, "%s=%s", name, value);
	if (putenv(s))
		nomem();
}

/*----------------------------------------------------------------------
 * Remove an environment variable.
 */

del_env(name)
char    *name;
{
	int     len;
	char    **e;

	if (!name)
		return;

	len = strlen(name);

	for (e = environ; *e; ++e)
	{
		char    c;

		if (strncmp(*e, name, len) != 0)
			continue;

		c = (*e)[len];
		if (c == '=' || c == '\0')
			break;
	}

	for (; *e; ++e)
		*e = *(e + 1);
}

/*----------------------------------------------------------------------
 * Allocate and clear.  If it fails, it takes the emergency exit.
 */

char *
zalloc(size)
unsigned size;
{
	char    *p;

	if ((p = malloc(size)) == NULL)
		nomem();

	Zero(p, size);
	return p;
}

/*----------------------------------------------------------------------
 * Reallocate to new size.  If it fails, it takes the emergency exit.
 */

char *
srealloc(ptr, size)
char    *ptr;
unsigned size;
{
	char    *p;

	if ((p = realloc(ptr, size)) == NULL)
		nomem();

	return p;
}

/*----------------------------------------------------------------------
 * Make an allocated copy of a string.
 */

char *
copystr(s)
char    *s;
{
	char    *p;

	if (s == NULL)
		return NULL;

	if ((p = malloc((unsigned) strlen(s) + 1)) == NULL)
		nomem();

	(void) strcpy(p, s);
	return p;
}

/*----------------------------------------------------------------------
 * Emergency exit for memory loss.
 */

nomem()
{
	error("out of memory\n");
	leave(1);
}

/*----------------------------------------------------------------------
 * Return the last component of the given pathname.
 */

char *
basename(name)
char    *name;
{
	char    *b;

	if ((b = strrchr(name, '/')) != NULL)
		++b;
	else
		b = name;

	return (b);
}

/*----------------------------------------------------------------------
 * Check an address for validity.
 */

valid_address(addr)
char    *addr;
{
	char    *p;
	static char sanitize[] = SANITIZE;

	for (p = addr; *p; ++p)
	{
		if (strchr(sanitize, *p))
			return FALSE;
	}

	return TRUE;
}
