/* $Header: deliver.h,v 2.1 89/06/09 12:25:21 network Exp $
 *
 * General pull-it-together include file.
 *
 * $Log:	deliver.h,v $
 * Revision 2.1  89/06/09  12:25:21  network
 * Update RCS revisions.
 * 
 * Revision 1.10  89/06/09  12:23:44  network
 * Baseline for 2.0 release.
 * 
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>

#include "config.h"
#include "misc.h"
#include "context.h"
#include "dest.h"

/*----------------------------------------------------------------------
 * Global data
 */

extern  int     verbose;        /* Print debugging messages?            */
extern  int     dryrun;         /* Are we making a dry run?             */
extern  int     rundfiles;      /* Run delivery files at all?           */
extern  int     printaddrs;     /* Address resolution only?             */
extern  int     leavetemps;     /* Leave temp files for later perusal   */
extern  int     boxdelivery;    /* Args are mailboxes, not addresses    */
extern  char    *sender;        /* Who is sending this message?         */

extern  char    *progname;      /* Name this program was invoked under  */
extern  char    *hostname;      /* Name of this host                    */

extern  char    *sys_deliver;   /* Systemwide delivery file             */
extern  char    *post_deliver;  /* Post-user delivery file              */
extern  char    *user_deliver;  /* User delivery file                   */
extern  char    *shell;         /* Shell used to run delivery files     */

extern  int     eff_uid;        /* Returned by geteuid()                */
extern  int     eff_gid;        /* Returned by getegid()                */
extern  int     real_uid;       /* Returned by getuid()                 */
extern  int     real_gid;       /* Returned by getgid()                 */

extern  CONTEXT *eff_ct;        /* Context of effective uid             */
extern  CONTEXT *real_ct;       /* Context of real uid                  */

extern  int     trust_user;     /* Do we trust the user that called us? */
extern  int     trust_delfiles; /* Do we trust the delivery files?      */

/* Temp file indices: */
#define T_HDR      0    /* Message header                       */
#define T_BODY     1    /* Message body                         */
#define T_HDRCOPY  2    /* Copy of message header               */
#define T_BODYCOPY 3    /* Copy of message body                 */
#define T_MAX      4    /* Number of temp files                 */

extern  char    *ttype[T_MAX];  /* Temp file types (for messages)       */
extern  char    *tfile[T_MAX];  /* Temp file names                      */
extern  char    *tenv[T_MAX];   /* Temp file environment names          */
extern  int     tfd[T_MAX];     /* Temp file fd's                       */

extern  SIGFLAG got_sig;        /* We caught a signal and should exit   */

/*----------------------------------------------------------------------
 * Global functions
 */

char    *basename();
char    *gethost();
char    *copystr();
char    *derrmsg();
char    *zalloc();
char    *srealloc();

CONTEXT *name_context();
CONTEXT *uid_context();

FILE    *ct_popenv();
int     ct_pclose();

DEST    *dest();
DEST    *first_dest();
DEST    *next_dest();

time_t  unctime();
