char *ProgramId = "(C) Copyright 1987,\
    David Herron and the University of Kentucky Computer Science Dept.\n\
    ibsmtp Version 1.0";

/*
 * Rights are granted to use, distribute, modify, and distribute
 * modifications of this work, provided that you subscribe to
 * bsmtp-users@ms.uky.edu and describe there any modifications you 
 * make.
 */

/*
 * ibsmtp.c -- Input BSMTP style mail messages into the system.
 *
 * Originally written by David S. Herron, Thu Nov 20 16:47:29 EST 1986.
 *
 *	My E-mail addresses are:
 *		{BITNET,UUCP}:   david@ukma
 *		CSNET, Internet: david@ms.uky.edu
 *
 *--------------
 * This is the first official release of my BSMTP programs.  They've
 * been held up while mod.sources/comp.sources.unix were in flux,
 * but that allowed for Sjoerd Mullender <sjoerd@cs.vu.nl> to find
 * and fix a couple of bugs.  (Thanks muchly)!
 *	David Herron, Mon Jul 13 19:08:04 EDT 1987
 */

#include <sys/types.h>
#include <time.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>

/*
 * Path names for the various possible mail daemons.
 * If one fails, domail() tries the next one in line.
 */
#define RECVPROG "/usr/mmdf/chans/recvprog"
#define SENDMAIL "/usr/lib/sendmail"
#define BINMAIL "/bin/mail"

extern char **environ;

char *ReversePath = NULL;
char *Channel = NULL;
char *SendingDomain = NULL;
char *OurDomain = NULL;

/*
 * C PURISTS BEWARE!  This data structure is of a type which usually
 * causes confusion.  "ForwardPaths" is being used as a list (char *)'s.
 * Normally this would be declared as "char *a[size];" but I didn't
 * want to leave a limit on the number of ForwardPaths.  ForwardPaths
 * is manipulated ONLY in addpath().  Note the hook that if nForwardPaths
 * is 0 but ForwardPaths points somewhere, that the memory allocated
 * to it is free()'d.
 */
char **ForwardPaths = (char **)NULL;
int nForwardPaths = 0;

int Errors = 0;		/* bumped every time we have an error.
			 * If we have some, then we exit with
			 * an error status, and our calling shell
			 * script will be able to save the output
			 * for us.
			 */

FILE *dbgout;


/***********   First, some utility functions.    *****************/


/*
 * arpadate() -- make a string saying what time it is as specified
 * in RFC-822.  Note the year is %'d by 100 because the spec says
 * that the year is a 2DIGIT.  Won't this cause problems in another
 * 13 years or so?
 *
 * This routine was written on 4.3BSD, but using the SysVr3 manuals
 * for reference.  In particluar, the 4.3 manuals claim that time()
 * returns a long instead of a time_t.  Anyway, it works and it should
 * work everywhere.
 */
char *
arpadate()
{
	time_t now;
	struct tm *tmnow;
	static char buf[BUFSIZ];
	extern time_t time();
	static char *days[] = 
		{ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", NULL };
	static char *months[] = 
		{ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
		  "Aug", "Sep", "Oct", "Nov", "Dec", NULL };

	now = time((long *)0);
	tmnow = gmtime(&now);
	(void) sprintf(buf, "%s, %d %s %d %02d:%02d:%02d GMT",
		days[tmnow->tm_wday], tmnow->tm_mday, months[tmnow->tm_mon],
		tmnow->tm_year % 100, tmnow->tm_hour, tmnow->tm_min,
		tmnow->tm_sec);
	return(buf);
}

/*
 * killnl(s) -- kill a newline in s.
 */
void
killnl(s)
char *s;
{	
	char *s2, *index();

	if ((s2=index(s, '\n')) != NULL)
		*s2 = '\0';
}

/*
 * copystr(s) -- make a copy of the string.
 */
char *
copystr(s)
char *s;
{
	char *rval, *malloc(), *strcpy();

	if (!s)
		return((char *)NULL);
	rval = malloc((unsigned)(sizeof(char)*strlen(s)+1));
	return(strcpy(rval, s));
}

/*
 * copypath(s) -- make a copy of a string, but strip leading '<' 
 * and trailing '>'.  (i.e. suitable for copying <path> out of 
 * one of the BSMTP command lines.
 */
char *
copypath(s)
char *s;
{
	char *rval, *s2, *index(), *malloc(), *strcpy();

	if (!s)
		return(NULL);
	rval = malloc((unsigned)(strlen(s)+1));
	if ((s2=index(s, '<')) != NULL)
		(void) strcpy(rval, s2+1);
	else
		(void) strcpy(rval, s);
	if ((s2=index(rval, '>')) != NULL)
		*s2 = '\0';
	return(rval);
}

/*
 * stripsp(s) -- Strip out excess spacing from a string.
 *		(Only from the front and back of the string).
 */
void
stripsp(s)
char *s;
{
	char *outs, *ins;

	if (!s)
		return;
	outs = s;
	ins = s;
	while (*ins != '\0') {
		if (*ins == '\t')
			*ins = ' ';
		if (*ins == ' ') {
			if (*(ins-1) != ' ' && outs != s)
				*outs++ = *ins;
		}
		else
			*outs++ = *ins;
		ins++;
	}
	*outs++ = '\0';
}


/*
 * split(s) -- split a character string into its fields.
 *
 * The return value is a group of pointers into a pair of
 * static areas.  The first (veclist) is a pointer to the 
 * base of a vector of pointers which point at various parts
 * of the second area (buf).  
 *
 * The upshot of that is:
 *
 *	1) Don't expect the data to remain after a call to split,
 *	   so be prepared to make a copy of it.
 *	2) Be nice and don't muck with split()'s copy.
 *
 * Oh, one last thing.  Notice that the last element in veclist[]
 * is marked by being NULL.
 */
char **
split(s)
char *s;
{
	static char *buf = (char *)NULL;
	static int buflen = 0;
	static char **veclist = (char **)NULL;
	int nvecs;
	int slen;
	register char *sp, *lastp, *s2;
	char *malloc(), *realloc(), *index();

	if (!s)
		return((char **)NULL);
	if (veclist) {
		free((char *)veclist);
	}
	veclist = (char **)malloc((unsigned)(sizeof(char *)));
	veclist[0] = (char *)NULL;
	nvecs = 1;
	stripsp(s);
	slen = strlen(s);
	if (dbgout) fprintf(dbgout, "Original string \"%s\"\n", s);
	if (buflen < (slen+1)) {
		buflen = slen+1;
		if (buf)
			buf = realloc(buf, (unsigned)(sizeof(char)*buflen));
		else
			buf = malloc((unsigned)(sizeof(char)*buflen));
	}
	(void) strcpy(buf, s);
	for (lastp = sp = buf; *sp != '\0'; sp++) {
		if (*sp == ' ') {
			nvecs++;
			veclist = (char **)realloc((char *)veclist, 
				(unsigned)(sizeof(char *)*nvecs));
			(*(veclist+nvecs-1)) = (char *)NULL;
			(*(veclist+nvecs-2)) = lastp;
			*sp = '\0';
			if ((s2=index(lastp, '\n')) != NULL)
				*s2 = '\0';
			if (dbgout) 
				fprintf(dbgout, 
					"Part %d \"%s\"\n", 
					nvecs-2, veclist[nvecs-2]);
			lastp = sp+1;
		}
	}
	nvecs++;
	veclist = (char **)realloc((char *)veclist, 
		(unsigned)(sizeof(char *)*nvecs));
	veclist[nvecs-1] = (char *)NULL;
	veclist[nvecs-2] = lastp;
	if (dbgout) fprintf(dbgout, "Part %d \"%s\"\n", nvecs-2, lastp);
	return(veclist);
}

/*
 * lexequ(s1, s2) -- strcmp of s1 and s2, but ignoring case.
 */
int
lexequ(s1, s2)
register char *s1, *s2;
{
	register char c1, c2;

	if (dbgout) fprintf(dbgout, "lexequ(\"%s\", \"%s\")\n", s1, s2);
	if (!s1 && !s2)
		return(0);
	if (!s1 && s2)
		return(-1);
	if (s1 && !s2)
		return(1);
	while (*s1 && *s2) {
		if (islower(*s1))
			c1 = toupper(*s1);
		else
			c1 = *s1;
		if (islower(*s2))
			c2 = toupper(*s2);
		else
			c2 = *s2;
		/* printf("<%c,0%o> == <%c,0%o>?\n", c1, c1, c2, c2); */
		if (c1 != c2)
			break;
		s1++;
		s2++;
	}
	return(c1 - c2);
}

/********     Next, specific stuff for bsmtp processing    *******/

/*
 * addpath(s) -- Add address in s to address list.
 */
void
addpath(s)
char *s;
{
	int i;
	char *malloc(), *realloc();

	if (!s)
		return;
	if (!ForwardPaths || nForwardPaths==0) {
		if (ForwardPaths) {
			for (i=0; ForwardPaths[i]; i++)
				if (ForwardPaths[i])
					free(ForwardPaths[i]);
			free((char *)ForwardPaths);
		}
		nForwardPaths = 1;
		ForwardPaths = (char **)malloc((unsigned)(sizeof(char *)));
		ForwardPaths[0] = copypath(s);
		if (dbgout) fprintf(dbgout, "addpath(%s, 0)\n", ForwardPaths[0]);
	}
	else {
		nForwardPaths++;
		ForwardPaths = (char **)realloc((char *)ForwardPaths, 
					(unsigned)(sizeof(char *)*nForwardPaths));
		ForwardPaths[nForwardPaths-1] = copypath(s);
		if (dbgout) fprintf(dbgout, "addpath(%s, %d)\n", 
			ForwardPaths[nForwardPaths-1], nForwardPaths-1);
	}
}

/*
 * domail(f) -- Process that part of the input stream which is the
 * mail message (Between "DATA" and ".") and send it to the addresses
 * which have already been saved away.
 *
 * According to RFC821, lines in the DATA part which should have 
 * a leading "." have the dot doubled.  We need to remove the 
 * doubled dot here.
 */
int
domail(f)
FILE *f;
{
	FILE *tmpfil;
	char fname[40], buf[BUFSIZ], **argv;
	int argc, argp, i, pid;
	union wait status;
	extern char *mktemp();

	(void) strcpy(fname, "/tmp/bsmtxtXXXXXX");
	(void) mktemp(fname);
	(void) close(creat(fname, 0644));
	tmpfil = fopen(fname, "w");
	fprintf(tmpfil, "Received: ");
	if (SendingDomain)
		fprintf(tmpfil, "from %s ", SendingDomain);
	if (OurDomain)
		fprintf(tmpfil, "by %s ", OurDomain);
	if (ReversePath)
		fprintf(tmpfil, "for %s ", ReversePath);
	fprintf(tmpfil, "with BSMTP (1.0);\n\t%s\n", arpadate());
	while (fgets(buf, BUFSIZ, f) != NULL) {
		if (buf[0] == '.') {
			if (buf[1] == '\n' || buf[1] == '\0')
				break;
			else {
				(void) fputs(&(buf[1]), tmpfil);
				if (dbgout) (void) fputs(&(buf[1]), dbgout);
			}
		}
		else {
			(void) fputs(&(buf[0]), tmpfil);
			if (dbgout) (void) fputs(&(buf[0]), dbgout);
		}
	}
	(void) fclose(tmpfil);
	if (nForwardPaths == 0)
		return(1);
	if ((pid=fork()) == 0) {
		/* In child process */

		/* Need to exec a mailer with the file on stdin */
		(void) fclose(stdin);
		tmpfil = fopen(fname, "r");

/* First try RECVPROG */
		argc = 1 + 			/* "recvprog" */
			(Channel?2:0) +		/* -c Channel */
			(SendingDomain?2:0) +	/* -h SendingDomain */
			(ReversePath?2:0) +	/* -s ReversePath */
			nForwardPaths;
		argv = (char **)malloc((unsigned)(sizeof(char *)*(argc+1)));
		argp = 0;
		if (dbgout) fputs("recvprog", dbgout);
		argv[argp++] = "recvprog";
		if (Channel) {
			argv[argp++] = "-c";
			argv[argp++] = Channel;
			if (dbgout) fputs(Channel, dbgout);
		}
		if (SendingDomain) {
			argv[argp++] = "-h";
			argv[argp++] = SendingDomain;
			if (dbgout) fputs(SendingDomain, dbgout);
		}
		if (ReversePath) {
			argv[argp++] = "-s";
			argv[argp++] = ReversePath;
			if (dbgout) fputs(ReversePath, dbgout);
		}
		for (i=0; i<nForwardPaths; i++) {
			argv[argp++] = ForwardPaths[i];
			if (dbgout) fputs(argv[argp-1], dbgout);
		}
		argv[argp++] = NULL;
		if (dbgout) (void) fflush(dbgout);
		execve(RECVPROG, argv, environ);

		perror("recvprog failed, trying sendmail");

/* Gosh, it didn't work, try SENDMAIL */
		free((char *)argv);
		argc = 1 +			/* "sendmail" */
			(SendingDomain?1:0) +	/* "-ffrom" */
			nForwardPaths;
		argv = (char **)malloc((unsigned)(sizeof(char *)*(argc+1)));
		argp = 0;
		if (dbgout) fputs("sendmail", dbgout);
		argv[argp++] = "sendmail";
		if (ReversePath) {
			/* We won't need buf below here */
			(void) sprintf(buf, "-f%s", ReversePath);
			argv[argp++] = buf;
			if (dbgout) fputs(argv[argp-1], dbgout);
		}
		for (i=0; i<nForwardPaths; i++) {
			argv[argp++] = ForwardPaths[i];
			if (dbgout) fputs(argv[argp-1], dbgout);
		}
		argv[argp++] = NULL;
		if (dbgout) (void) fflush(dbgout);
		execve(SENDMAIL, argv, environ);

		perror("sendmail failed, trying binmail");

/* Gosh, it still didn't work... next try BINMAIL */
		free((char *)argv);
		argc = 1 +			/* "mail" */
			(ReversePath?2:0) +	/* -f from */
			nForwardPaths;
		argv = (char **)malloc((unsigned)(sizeof(char *)*(argc+1)));
		argp = 0;
		if (dbgout) fputs("mail", dbgout);
		argv[argp++] = "mail";
		if (ReversePath) {
			/* We won't need buf below here */
			argv[argp++] = "-f";
			argv[argp++] = ReversePath;
			if (dbgout) fputs(argv[argp-1], dbgout);
		}
		for (i=0; i<nForwardPaths; i++) {
			argv[argp++] = ForwardPaths[i];
			if (dbgout) fputs(argv[argp-1], dbgout);
		}
		argv[argp++] = NULL;
		if (dbgout) (void) fflush(dbgout);
		execve(BINMAIL, argv, environ);

		perror("binmail failed, nowhere to turn");

		/* Gosh, it STILL didn't work, but we tried everything! */
		if (dbgout) fputs("AAAARRRRGGGGHHHH!!!!", dbgout);
		exit(1);
	}
	else {
		/* In parent, first order of business is to wait for the child */
		while (wait(&status) != pid)
			;
		/*
		 * Need to do something in case status indicates error.
		 * Right now, it'll just disappear into thin air.
		 * Well, not exactly... 
		 */
		(void) unlink(fname);
		if (status.w_status != 0)
			return(1);
		else
			return(0);
	}
	return(1);
}




/*
 * parse(f) -- parse the bsmtp thing on the given file.
 */
int
parse(f)
FILE *f;
{
	char **words;
	char buf[BUFSIZ];

init_state:
	if (fgets(buf, BUFSIZ, f) == NULL) {
		/* early EOF */
		goto seen_QUIT;
	}
	killnl(buf);
	words = split(buf);
	if (lexequ("HELO", words[0]) == 0) {
		if (dbgout) 
			fprintf(dbgout, "Howdy %s, how the hell are ya?\n", words[1]);
		SendingDomain = copystr(words[1]);
		goto seen_HELO;
	}
	else if (lexequ("NOOP", words[0]) == 0)
		goto init_state;
	else if (lexequ("RSET", words[0]) == 0)
		goto init_state;
	else
		goto seen_ERROR;

seen_HELO:
	if (fgets(buf, BUFSIZ, f) == NULL)
		goto seen_QUIT;
	killnl(buf);
	words = split(buf);
	if (lexequ("MAIL", words[0]) == 0) {
		if (lexequ("FROM:", words[1])) {
			/* MAIL FROM: <path> */
			ReversePath = copypath(words[2]);
		}
		else {
			/* MAIL FROM:<path> */
			ReversePath = copypath(index(words[1], ':'));
		}
		if (dbgout) 
			fprintf(dbgout, "Oh, you're sending from %s eh?\n", ReversePath);
		goto seen_MAIL;
	}
	else if (lexequ("NOOP", words[0]) == 0)
		goto seen_HELO;
	else if (lexequ("TICK", words[0]) == 0)
		goto seen_HELO;
	else if (lexequ("VERB", words[0]) == 0)
		goto seen_HELO;
	else if (lexequ("QUIT", words[0]) == 0)
		goto seen_QUIT;
	else if (lexequ("RSET", words[0]) == 0)
		goto seen_RSET;
	else
		goto seen_ERROR;

seen_MAIL:
	if (fgets(buf, BUFSIZ, f) == NULL)
		goto seen_QUIT;
	killnl(buf);
	words = split(buf);
	if (lexequ("RCPT", words[0]) == 0) {
		if (lexequ("TO:", words[1])) {
			/* RCPT TO: <path> */
			addpath(words[2]);
		}
		else {
			/* RCTP TO:<path> */
			addpath(index(words[1], ':'));
		}
		goto seen_MAIL;
	}
	else if (lexequ("DATA", words[0]) == 0)
		goto seen_DATA;
	else if (lexequ("RSET", words[0]) == 0)
		goto seen_RSET;
	else if (lexequ("NOOP", words[0]) == 0)
		goto seen_MAIL;
	else if (lexequ("TICK", words[0]) == 0)
		goto seen_MAIL;
	else if (lexequ("VERB", words[0]) == 0)
		goto seen_MAIL;
	else if (lexequ("QUIT", words[0]) == 0)
		goto seen_QUIT;
	else
		goto seen_ERROR;

seen_RSET:
	if (ReversePath) {
		free(ReversePath);
		ReversePath = (char *)NULL;
	}
	nForwardPaths = 0;
	goto seen_HELO;

seen_DATA:
	if (domail(f) != 0) {
		if (dbgout) fprintf(dbgout, "oops\n");
		Errors++;
	}
	goto seen_RSET;

seen_QUIT:
	return(0);

seen_ERROR:
	return(1);
}


/*
 * doparse(s) -- open file named in s and run parse on it.
 */
void
doparse(s)
char *s;
{
	char fname[BUFSIZ], buf[BUFSIZ];
	FILE *infile;

	if (!s) {
		/*
		 * If the creat() fails then everything else will
		 * fail and the whole file will be dropped on the
		 * floor.  What's a mother to do?
		 */
		(void) strcpy(fname, "/tmp/bsinXXXXXX");
		(void) mktemp(fname);
		(void) close(creat(fname, 0600));
		infile = fopen(fname, "w");
		while (fgets(buf, BUFSIZ, stdin) != NULL)
			fputs(buf, infile);
		(void) fclose(infile);
		infile = fopen(fname, "r");
	}
	else {
		infile = fopen(s, "r");
	}
	if (infile && parse(infile)) {
		Errors++;
	}
	else {
		(void) unlink(fname);
	}
}

/*
 * main(argc, argv) -- main program.
 */
main(argc, argv)
int argc;
char **argv;
{
	int i;
	int didanything = 0;

	Errors = 0;
	for (i=1; i<argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
			case '\0': /* "-" 	read stdin */
				if (dbgout) fprintf(dbgout, "doparse(NULL)\n");
				didanything++;
				doparse((char *)NULL);
				break;
			case 'c': /* -c channel	specify a channel */
				if (dbgout)
					fprintf(dbgout, "Channel = %s\n", argv[i+1]);
				Channel = argv[i+1];
				i++;
				break;
			case 'd': /* -d file	enable debugging messages */
				dbgout = fopen(argv[i+1], "w");
				if (!dbgout) perror("opening dbgout");
				i++;
				break;
			case 'D': /* -D domain	specify the local domain name */
				if (dbgout)
					fprintf(dbgout, "OurDomain = %s\n", argv[i+1]);
				OurDomain = argv[i+1];
				i++;
				break;
			default: /* eh? */
				if (dbgout)
					fprintf(dbgout, "Unknown option %c i=%d\n",
						argv[i][1], i);
				break;
			}
		} 
		else {		/* anything else is a file to parse */
			if (dbgout) fprintf(dbgout, "doparse(%s)\n", argv[i]);
			didanything++;
			doparse(argv[i]);
		}
	}
	if (!didanything) {
		/* Specifying no files means to try stdin */
		if (dbgout) fprintf(dbgout, "doparse(stdin)\n");
		didanything++;
		doparse((char *)NULL);
	}
	if (Errors > 0)
		exit(1);
	else
		exit(0);
	/*NOTREACHED*/
}
