#define A1NSETS 3			/* number of character sets */
#define MAX_SETS 5		/* max number of char sets */
#define A1NPRINTS 86		/* number of printable characters */
#define MAX_PRINTS 96
#define TOTAL_PRINTS 128	/* highest ASCII printable possible */
#define A1FPRINT '%'		/* first printable to be used (ABE1)*/
#define SFBYTE 31		/* index of first line number byte in
					line number char set table */
#define NUM_SAFE 64
#define A1LPRINT 'z'

#ifndef INB_LEN
# define INB_LEN 10000		/* input buffer for pre-pass */
#endif
#define MAX_LLEN 80		/* max output line len */
#define FNAMELEN 255		/* max len of file name */
#define CSUM_MOD 65536l		/* modulus for checksums */

typedef char bool;


	/* read mode for binary files in this OS */
#ifdef msdos
	/* in case of DOS, prepare for binary read mode */
# define READMODE "rb"
# define WRITEMODE "wb"
# include <fcntl.h>
# include <io.h>
# define DIRCHARS "/\\:"
# define OUROS "msdos"
#else
# define READMODE "r"
# define WRITEMODE "w"
# define DIRCHARS "/"
# define OUROS "unix"
#endif

#ifndef DECODER
#define DECODER "td%s"
#endif

	/* methods of processing */
#define ONEPASS 1
#define TWOPASS 2

struct frq {
	long freq;
	int bytenum;
	};

#define LB_LEN 4		/* length of look ahead buffer */

#define MPERLINE 65

#define MAX_UNAME 14		/* max len of universal name */
#define MAX_FNAME 255		/* maximum file names */
#define MAX_BLOCKS 255
#define MAX_COMLEN MAX_LLEN	/* maximum command len */
#define OUR_VERSION 1000
#define MAX_STYLE 8		/* max len of a style code */

#define OUR_EOF 256

/* general names for control characters in decoder */
#define MCHAR 0
#define SHIFTX 1
#define SHIFTXX 2
#define SHIFTXcX 3
#define CHANGE_SET 4
#define RUNLENGTH 5

/* for ABE1 format */
#define SETXX '!'
#define NEWSET1 '{'
#define SET10X '}'

/* for ABE2 format */
#define A2SETXX '"'
#define A2NEWSET1 '+'
#define A2X0XSET  ":;<=>?@_"
	


#define TRUE 1
#define FALSE 0

/* header characters */

#define CODE_HEAD '"'
#define MAIN_HEAD '#'
#define SUB_HEAD '$'

#define DEF_BLOCKSIZE 40000L

#define VERNUM 1000
#define EARLIEST_VERNUM 1000
#define EARLIEST_SIMD 1000

#define FULL_MAP 255		/* all 8 lines of the character map */

extern char *malloc();
extern char *allocstring();
extern FILE *openout();
extern char *lineconv();
extern long atol();

struct fseen_list {
	char *name_seen;
	struct fseen_list *next_fs;
	};

/* codes for return from decoder */
#define GOOD_FILE 0
#define NO_DATA 1
#define UUDECODE -1

/* encoding styles */
#define UNDEF -1
#define ABE1 0
#define ABE2 1
#define UUENCODE 2
#define TEXT 3
/* crc information */
#define TABSIZE         256            /* no of entries in table */
typedef unsigned long   tcrc;          /* type of crc value */
/* Gary S. Brown's CRC32 macro */
#define UPDC32(b, c) (crctab[((int)c ^ b) & 0xff] ^ ((c >> 8) & 0x00FFFFFF))
