
module gmf_$extend;

DEFINE gmf_$inquire;

%include '/sys/ins/base.ins.pas';
%include '/sys/ins/streams.ins.pas';

procedure gmf_$inquire(
        in id: stream_$id_t;
        out x_dim,y_dim, bpi: integer; out status: status_$t );  EXTERN;

procedure gmf_$inquire;

const
         gmf_$not_gmf =      16#06040006;

TYPE  header_t = PACKED RECORD
        kind : INTEGER;    { type of header }
     version : INTEGER;    {                }
           x : INTEGER;    { x dimension of bitmap in bits }
           y : INTEGER;    { y dimension of bitmap in bits }
     gmf_bpi : INTEGER;    { resolution of data in bits per inch, to whatever degree of }
                           {  accuracy is feasible (0 means each bit is one dot         }
                           {  regardless of the dot size of the output device)          }
      END;

  wordsin_t = array [0..1023] of pinteger;     { scanline-size array of read words from streams file }
  wordsin_ptr_t = ^wordsin_t;

var
  t,lines       :integer;                    { counters }
  header        :header_t;                   { header identifier }
  wordsin       :wordsin_t;                  { input buffer from map file }
  bufptr,retptr :wordsin_ptr_t;
  retlen        :integer32;
  seek_key      :stream_$sk_t;

begin
  stream_$seek( id, stream_$rec, stream_$absolute, 1, status );
  if status.all <> status_$ok then begin
    status.fail := true;
    return;
  end;

  bufptr := addr(wordsin);

  { setup header information from map file }
  stream_$get_rec (id,bufptr,SIZEOF(header_t),retptr,retlen,seek_key,status);

  if status.all <> status_$ok then begin
    status.fail := true;
    return;
  end;
  for t := 0 to 10 do wordsin[t] := retptr^[t];

  with header do begin
    kind := wordsin[0];
    version := wordsin[1];
    x := wordsin[2];
    x_dim := wordsin[2];
    y := wordsin[3];
    y_dim := wordsin[3];
    gmf_bpi := wordsin[4];
    bpi := wordsin[4];
  end;

  { re-wind the input for future use... }
  stream_$seek( id, stream_$rec, stream_$absolute, 1, status );
  if status.all <> status_$ok then begin
    status.fail := true;
    return;
  end;
                     
  { is opened file really a gmf map file? }
  if header.kind <> 1 then 
    begin
      status.all :=  gmf_$not_gmf;
      return;
    end;

end;
