/*
   Yet another hack with P. Rowley's (U Toronto) macpaint code - this 
   extracts the top left portion and spits it out in hex, for putting illo's
   in Scribe files.

   J.W. Peterson
   Computer Science Department
   University of Utah.
*/

#include <stdio.h>

#define and &&
#define or ||

/*  Flags & defaults for user */

#define FFLAG          'f'	/* -f macpaint_file (input macpaint file) */
#define COLFLAG        'c'	/* -c col_width (column width to center on) */
#define HEIGHTFLAG     'h'      /* -h height    (height of Scribe picture) */
#define SIZEFLAG       's'      /* -s x y   (Size of macpaint picture (in pixels)) */
#define UPFLAG         'u'	/* -u updist (amount to translate up) */
#define POSTFLAG       'P'      /* -P postfile (PostScript file to use) */

/* Default values */

/* These determine the size of the picture (values here are for exactly the
 * size of the window MacPaint displays (416 x 240)) */

/* This defines the width of the scanline accepted, IN BYTES (which equals
 * the number of pixels / 8)
 */
#define LINE_WIDTH  52
#define DEF_SCANLINES      240 	/* This defines the height (# of scanlines) */

#define OUTDEF         stdout
#define POSTDEF        "/v/misc/mac/lw/scribe_pics/scribepic.ps"

#define COLUMNDEF      6.5     /*  Assume 6.5" text column */
#define HEIGHTDEF      2       /*  Assume 2" height */
#define UPDEF          0       /*  Assume 0" move UP */

int line_width, scanlines;

char in_line[72];

FILE *infil, *fopen();

main(argc,argv) 
int argc;
char *argv[];
{
    int i, j, c;
    int size_x, size_y;    		/* Size of MacPaint picture grabbed*/
    float columnwidth, height, up, atof();
    FILE *fpost;
    char postfile[255], filename[255];

    infil = stdin;      /* assume stdin */
    filename[0] = '\0';
    strcpy(postfile, POSTDEF);

    /* Scribe defaults */
    height = HEIGHTDEF;
    columnwidth = COLUMNDEF;
    up = UPDEF;

    /* Default size clipped from MacPaint page */
    size_x = LINE_WIDTH * 8;
    size_y = DEF_SCANLINES;

    /* Command line parsing */

    for (i=1; i<argc; i++)
    {
	if (argv[i][0] == '-')
	{
	    switch (argv[i][1])
	    {
		case FFLAG:    strcpy(filename, argv[i+1]);
		               break;
             
                case POSTFLAG: strcpy(postfile, argv[i+1]);
                               break;

		case COLFLAG: columnwidth = atof( argv[i+1] );
		               break;

		case HEIGHTFLAG: height = atof( argv[i+1] );
		                 break;

		case UPFLAG:   up = atof( argv[i+1] );
		               break;

		case SIZEFLAG: size_x = atoi( argv[i+1] );
		               size_y = atoi( argv[i+2] );
			       break;
		default:
                               printf(
"Usage: extract_top [-f macpaintfile] [-P header.ps] [-c width] [-h height] \n			            [-s x_size y_size] [-u up]\n");
	    		       exit(1);
			       break;
	    }
	}
    }

    if ((strlen(filename) > 0) and ((infil = fopen(filename, "r")) == NULL)) {
        printf("Can't open input file %s\n", filename);
        exit(1);
    }

    if ((fpost = fopen(postfile, "r")) == NULL) {
        printf("Can't open PostScript header file %s\n", postfile);
        exit(1);
    }

    /* read and discard 512 byte MacPaint header */
    for (i=0; i<512; i++)
	    getc(infil);

    /* Copy the postscript header to stdout */
    while ((c = getc(fpost)) != EOF)
        putc(c, stdout);

    line_width = (int) size_x / 8;	/* Convert to number of bytes */
    scanlines = size_y;

    /* Print a preamble describing size and shape */
    printf( "1 %d %d %f %f %f\n", line_width, scanlines,
             columnwidth, height, up );

    /* read and process each of scanlines scan lines (others get tossed) */
    for (i=0; i < scanlines; i++)	
    {
	    do_scan();
    }
}

do_scan() {
	int in_pos, count, data_byte, mcount;
	unsigned int raw_data;

	in_pos = 0;
	while (in_pos < 72) {
		count = getc(infil);

 		if (count > 127) count -= 256;

		/* Prevent computed count from exceding line_width */
		mcount = count;		/* Modified count */

		/* run too long */
                if ((count >= 0) and ((count + 1 + in_pos) > line_width))
		    mcount = line_width - 1 - in_pos;

		/* Data string too long */
		if ((count < 0) and ((-count + 1 + in_pos) > line_width))
		    mcount = -( line_width - in_pos -1 );
		    
		if (in_pos < line_width)
		    printf ( "%02X", (mcount+256) & 0xFF );

		if (count >= 0) {		/* run of raw bytes */
			count++;		/* # of bytes to read */
			while (count--) {
				raw_data = getc(infil);
				if (in_pos < line_width)
				    printf ( "%02X", raw_data );
				in_pos++;
			}
		}
		else {				/* run of repeated byte */
			count = -count+1;	/* repetition factor */
			data_byte = getc(infil);  /* byte to repeat */
			if (in_pos < line_width)
			    printf ( "%02X", data_byte );

			while (count--)		/* Kinda dumb... */
			    in_pos++;
		}
	}
	printf ("\n");
}

