.TH DRAWIMP LOCAL "17 December 1985"
.SH NAME
drawimp \- convert MacDraw files to imPRESS format
.SH SYNOPSIS
.B drawimp
[ options ] files
.SH DESCRIPTION
.vs -1p
.I Drawimp
converts the named MacDraw format files into imPRESS format for printing on
an Imagen laser printer.
.I Drawimp
can be run in two modes.  In the normal mode, imPRESS output from 
all the files listed on the command line will be written to the standard
output.
The imPRESS output contains the required headers and 
should be ready to print with no changes or additions.  If
.I drawimp
is run with the 
.B \-t
option, the program will create a separate output file for each input file.
These output files will be in the proper format 
for merging with 
.I LaTeX
output files for putting figures in documents.  
.PP
The following options may be used
.TP
.B  \-d
Write debugging information to standard error.
This consists of a list of the objects in the file, their location in
MacDraw coordinates, and various attributes.
.TP
.BI \-p list
Print only pages whose row and column numbers appear in a comma-separated
.I list
of paired row and column numbers in the form
.I r:c,
or paired rows and columns ranges in the form
.I r1-r2:c1-c2.
A range
.IB r1 \- r2
means rows
.I r1
through
.I r2
inclusive; an initial
.I \-r2
means rows 1 though
.I r2
inclusive; and a final
.IR r1 \-
means from
.I r1
to the last row.  The same applies for the column specifications.
.TP
.B \-t
Write imPRESS output to separate output files (one for each input file)
without a header or trailing
.I Endpage
or
.I Eof
bytes.  This option should be used if the output is intended for combining
with other imPRESS data.
In this mode, the page select option
.B \-p
is not allowed and only the upper left
page of the drawing will be processed.
The picture on this page be shifted on the coordinate system as if it had
been in the upper left corner of the 8x10 page.
If the name of an input file ends with
.I \.data 
then the output file will be the same name as the input file with the
.I \.data
replaced by
.I \.imp.
Otherwise, the output file name will be the input file name with
.I \.imp
appended to it.
.TP
.BI \-R resolution
Sets assumed printer resolution (in dots per inch).
.SH FILES
/tmp/McD*.\c
.I rcc
- temporary file for imPRESS data for the page at row
.I r
and column
.I cc
.SH BUGS
Multiple page objects, PICT objects (things from MacPaint via the clipboard),
and smoothed polygons are not currently supported.
.PP
All MacDraw files containing pictures to be included in a single
.I LaTeX
document must be processed by
.I drawimp
(with the
.B \-t
option)
at the same time.  If this is not done, the fonts used for text in the 
pictures will get mixed up.
.PP
The program ignores any information in the file about paper size or 
orientation.  It assumes a paper size of 8x10 inches and will 
ignore any object that crosses an 8x10 inch page boundary,
Because of this, it is best to use that paper size when creating the drawing
to better see how the output will be broken up.
.PP
The program is designed to convert MacDraw files which are in the format
produced by \*(lqMacDraw Version 1.7 3/18/85\*(rq and may not be compatible
with files produced by other versions of MacDraw.
.SH AUTHOR
Allan G. Weber (Weber%Brand@USC-ECL.ARPA), University of Southern California,
Signal and Image Processing Institute
