/*
	This is an include file for the MacDraw file reading program.
	Some of the structs are not really used but are here to show the
	way data is stored in the file.
	In the structs, char = 1 byte, short = 2 bytes.

	Allan Weber (Weber%Brand@USC-ECL)
	USC Signal and Image Processing Institute

	Last edit: 5-Dec-85
*/

#define DEF_RES		300		/* default Imagen resolution */
#define	H_SHIFT		18		/* shifts to center page on paper */
#define	V_SHIFT		36
#define TEXTURE_FAMILY	95
#define FONT_FAMILY_TOP	(TEXTURE_FAMILY - 1)
#define	TEMP_PREFIX	"/tmp/McDXXXXXX"
#define TEX_EXT		".imp"		/* file extension for LaTex files */
#define MAC_EXT		".data"		/* file extension for MacDraw file */

#define	MAC_H_SIZE	576
#define MAC_V_SIZE	720
#define MAC_H_PAGES	12
#define MAC_V_PAGES	5
#define	HEADER_SIZE	512
#define	ARROW_ANGLE	15

/*
The following #define values relate to the different attributes used by
MacDraw for various objects.
*/

/* Text style */
#define	PLAIN		0
#define BOLD		1
#define	ITALIC		2
#define	UNDERLINE	4
#define	HOLLOW		8
#define	SHADOW	       16

/* Font type */
#define CHICAGO		1
#define GENEVA		2
#define	NEW_YORK	3

/* Font size */
#define	SIZE_9		1
#define SIZE_10		2
#define	SIZE_12		3
#define	SIZE_14		4
#define	SIZE_18		5

/* Text spacing */
#define	SINGLE		1
#define THREE_HALF	2
#define	DOUBLE		3

/* Text alignment */
#define	LEFT		1
#define	CENTER		2
#define	RIGHT		3

/* Line width */
#define LINE_0		1
#define	LINE_1		2
#define	LINE_2		3
#define	LINE_4		4
#define	LINE_6		5

/* Arrow direction */
#define NO_ARROW	0
#define	RIGHT_ARROW	1
#define	LEFT_ARROW	2
#define	BOTH_ARROW	3

/*
The following structs are for various data structures used in the
MacDraw data records.
*/

struct lcoord {		/* long coordinate - radix point between halves */
	unsigned short i,f;
};

struct lpoint {		/* long point */
	struct lcoord v,h;
};

struct lrect {		/* long rectangle */
	struct lcoord top, left, bottom, right;
};

struct srect {		/* short rectangle */
	short top, left, bottom, right;
};

struct frect {		/* float rectangle */
	float top, left, bottom, right;
};

struct bpoint {	/* incremental point */
	char x,y;
};

/*
The following are structs for the data records.
Fields with unknown purposes are named Z1, Z2, etc.
*/

struct MDheader {	/* record header for each object */
	char code;
	char Z1,Z2,Z3;
	char line;
	char pen;
	char fill;
	char special;
};

struct MDtext {		/* Text record */
	short Z1,Z2;
	char style;
	char font;
	char size;
	char spacing;
	char alignment;
	char angle;
	short count;
	struct srect rect;
};

struct MDvector {	/* Vector record (right angle and sloped) */
	struct lpoint start, stop;
};

struct MDbox {		/* Rectangle, Ellipse, and RoundRect record */
	struct lrect rect;
};

struct MDarc {		/* Arc record */
	struct lrect rect;
	unsigned short start, angle;
};

struct MDgroup {	/* Group identifier record */
	struct lrect rect;
	unsigned short Z1, Z2, Z3, Z4, Z5, Z6, Z7, Z8;
};

struct MDpolygon {	/* Polygon record */
	unsigned short Z1;
	unsigned short rec_size;
	unsigned short points;
	struct lrect rect;
	char closed;
	char Z2;
};

struct MDcurve {	/* Curve record */
	unsigned short Z1;
	unsigned short rec_size;
	unsigned short points;
	struct lrect rect;
	char closed;
	char Z2;
	struct lpoint start;
};

#define MAX_RECORD 40
