/*
This file contains functions for outputting Impress codes to a file.
Not all functions have been implemented, only those needed so far.
*/

#include <stdio.h>

/*
The following #defines are copied from the Imagen supplied file "imPcodes.h"
*/
#define	imP_SP			128
#define	imP_SP1			129
#define	imP_OLD_MMOVE		130
#define	imP_MPLUS		131
#define	imP_MMINUS		132
#define	imP_MMOVE		133
#define	imP_SMOVE		134

#define	imP_SET_ABS_H		135
#define	imP_SET_REL_H		136
#define	imP_SET_ABS_V		137
#define	imP_SET_REL_V		138

#define	imP_SRULE		192
#define	imP_BRULE		193

#define	imP_SET_HPOS		195
#define	imP_SET_VPOS		196
#define	imP_CRLF		197
#define	imP_SGLY		198
#define	imP_BGLY		199
#define	imP_DELG		200
#define	imP_DELC		201
#define	imP_DELF		202
#define	imP_MAKE_TEXTURE	203

#define	imP_SET_HV_SYSTEM	205
#define	imP_SET_ADV_DIRS	206
#define	imP_SET_FAMILY		207
#define	imP_SET_IL		208
#define	imP_SET_BOL		209
#define	imP_SET_SP		210
#define	imP_PUSH		211
#define	imP_POP			212
#define	imP_PAGE		213
#define	imP_SET_PUSH_MASK	214
#define	imP_ENDPAGE		219

#define	imP_CREATE_FAMILY_TABLE	221
#define	imP_CREATE_MAP		222

#define	imP_SET_PUM		225
#define	imP_CIRC_ARC		150
#define	imP_ELLIPSE_ARC		151
#define	imP_CIRC_SEGM		160
#define	imP_CREATE_PATH		230
#define	imP_SET_TEXTURE		231
#define	imP_SET_PEN		232
#define	imP_FILL_PATH		233
#define	imP_DRAW_PATH		234
#define	imP_BITMAP		235
#define	imP_SET_MAGN		236
#define	imP_FORCE_GLY_DEL	240
#define	imP_DEFINE_MACRO	242
#define	imP_EXEC_MACRO		243
#define	imP_DEFINE_FILE		244
#define	imP_EXEC_FILE		245
#define	imP_NOOP		254
#define	imP_EOF			255

static FILE *impfp;

FILE *impout(fp)
FILE *fp;
{
	FILE *oldfp;
	oldfp = impfp;
	impfp = fp;
	return(oldfp);
}

static outb(x)
int x;
{
	putc(x & 0xff, impfp);
}

static outw(x)
int x;
{
	outb(x >> 8);
	outb(x);
}

static outs(s,n)
char *s;
int n;
{
	fwrite(s,1,n,impfp);
}

/****************************************************************************/

imP_bitmap(op_type, hsize, vsize, bits)
int op_type, hsize, vsize;
char *bits;
{
	outb(imP_BITMAP);
	outb(op_type);
	outb(hsize);
	outb(vsize);
	if (bits != NULL)
		outs(bits, hsize * vsize * 128);
}

imP_bgly(rotation,family,member,adv_wid,width,left_off,height,top_off,mask)
int rotation,family,member,adv_wid,width,left_off,height,top_off;
char *mask;
{
	int n;
	outb(imP_BGLY);
	outw(((rotation&0x03) << 14) + ((family&0x7f) << 7) + (member&0x7f));
	outw(adv_wid);
	outw(width);
	outw(left_off);
	outw(height);
	outw(top_off);
	if (mask != NULL) {
		n = height * ((width + 7) / 8);
		while (n--)
			outb(*mask++);
	}
}

imP_create_path(vertex_count, h, v)
int vertex_count, *h, *v;
{
	outb(imP_CREATE_PATH);
	outw(vertex_count);
	while (vertex_count--) {
		outw(*h++);
		outw(*v++);
	}
}

imP_crlf()
{	outb(imP_CRLF); }

imP_draw_path(operation_type)
int operation_type;
{
	outb(imP_DRAW_PATH);
	outb(operation_type);
}

imP_ellipse_arc(radiusa,radiusb,alphaoff,alpha0,alpha1)
int radiusa,radiusb,alphaoff,alpha0,alpha1;
{
	outb(imP_ELLIPSE_ARC);
	outw(radiusa);
	outw(radiusb);
	outw(alphaoff);
	outw(alpha0);
	outw(alpha1);
}

imP_endpage()
{	outb(imP_ENDPAGE); }

imP_eof()
{	outb(imP_EOF); }

imP_fill_path(operation_type)
int operation_type;
{
	outb(imP_FILL_PATH);
	outb(operation_type);
}

imP_member(code)
int code;
{
	outb(code);
}

imP_mminus()
{	outb(imP_MMINUS); }

imP_mmove(deltam)
{
	outb(imP_MMOVE);
	outw(deltam);
}

imP_mplus()
{	outb(imP_MPLUS); }

imP_noop()
{	outb(imP_NOOP); }

imP_set_abs_h(new_h)
int new_h;
{
	outb(imP_SET_ABS_H);
	outw(new_h);
}

imP_set_abs_v(new_v)
int new_v;
{
	outb(imP_SET_ABS_V);
	outw(new_v);
}

imP_set_bol(line_begin)
int line_begin;
{
	outb(imP_SET_BOL);
	outw(line_begin);
}

imP_set_family(family)
int family;
{
	outb(imP_SET_FAMILY);
	outb(family);
}

imP_set_hv_system(origin,axes,orientation)
int origin, axes, orientation;
{
	int x;
	x = ((origin & 3) << 5) + ((axes & 3) << 3) + (orientation & 1);
	outb(imP_SET_HV_SYSTEM);
	outb(x);
}

imP_set_il(inter_line)
int inter_line;
{
	outb(imP_SET_IL);
	outw(inter_line);
}

imP_page()
{	outb(imP_PAGE); }

imP_set_pen(diameter)
int diameter;
{
	outb(imP_SET_PEN);
	outb(diameter);
}

imP_set_pum(mode)
int mode;
{
	outb(imP_SET_PUM);
	outb(mode & 1);
}

imP_set_rel_h(delta_h)
int delta_h;
{
	outb(imP_SET_REL_H);
	outw(delta_h);
}

imP_set_rel_v(delta_v)
int delta_v;
{
	outb(imP_SET_REL_V);
	outw(delta_v);
}

imP_set_texture(family,member)
int family, member;
{
	outb(imP_SET_TEXTURE);
	outw(((family & 0x7f) << 7) + (member & 0x7f)); 
}

imP_set_sp(space_size)
int space_size;
{
	outb(imP_SET_SP);
	outw(space_size);
}

imP_smove(deltas)
int deltas;
{
	outb(imP_SMOVE);
	outw(deltas);
}

imP_sp()
{	outb(imP_SP); }


