#include	<stdio.h>
#include	"applic.h"

#define	NPL		20+1	/* max num of places */
#define	NTR		20	/* max num of transitions */
#define	NIN		6	/* max num of input places per transition */
#define	NOUT		6	/* max num of output places per transition */
#define	NLEN		10	/* max len of transition and place names */

void	PrintProb ();
void	fire ();

/*****************************************************************************
 *
 *	G L O B A L   D A T A   A R E A
 */

struct	node_st	{	/* empty DIGT work node */
	index	next;		/* to next trans to consider in Generate */
	int	mark [1];	/* marking vector, one elt per place */
	};

struct	tr_st	{	/* transition table */
	char	name	[NLEN];
	index	in	[NIN];	/* input places */
	int	need	[NIN];	/* multiplicity of each input place */
	index	out	[NOUT];	/* output places */
	int	give	[NOUT];	/* multiplicity of each output place */
	}		tr [NTR];

struct	pln_st	{	/* place name table */
	char	name [NLEN];
	}		pln [NPL];

int	ntr = 0;		/* num of transition table entries */
int	npl = 1;		/* num of place name table entries */

#define	NODE_SIZE	sizeof (index) + npl * sizeof (int)
#define	GLOBAL_SIZE	sizeof (ntr) + ntr * sizeof (struct tr_st) + \
			sizeof (npl) + npl * sizeof (struct pln_st)

/*****************************************************************************
 *
 *	D I G T   I N T E R F A C E   R O U T I N E S
 */

void
ApplicInit (machines, name, pnodesz, pglobsz, pwaitch)
	int	machines;
	char	*name;
	int	*pnodesz, *pglobsz;
	bool	*pwaitch;	{

	extern	FILE	*yyin;

	if ((yyin = fopen (name, "r")) == NULL)
		abort ("can't open input file")

	yyparse ();
	*pnodesz = NODE_SIZE;
	*pglobsz = GLOBAL_SIZE;
	*pwaitch = FALSE;
	}

void
ReadGlobal (pglob)
	int	*pglob;	{

	struct	tr_st	*tp;
	struct	pln_st	*pp;
	int	i;

	*pglob++ = GLOBAL_SIZE;
	*pglob++ = ntr;
	*pglob++ = npl;

	tp = (struct tr_st *) pglob;
	for (i = 0 ; i < ntr ; i++)  *tp++ = tr [i];
	pp = (struct pln_st *) tp;
	for (i = 0 ; i < npl ; i++)  *pp++ = pln [i];
	}

void
WriteGlobal (pglob)
	int	*pglob;	{

	struct	tr_st	*tp;
	struct	pln_st	*pp;
	int	i;

	pglob++;
	ntr = *pglob++;
	npl = *pglob++;

	tp = (struct tr_st *) pglob;
	for (i = 0 ; i < ntr ; i++)  tr [i] = *tp++;
	pp = (struct pln_st *) tp;
	for (i = 0 ; i < npl ; i++)  pln [i] = *pp++;
	}

int
Hash (pbuf, modulus)
	char	*pbuf;
	int	modulus;	{

	unsigned int	sum = 0;
	index	i;
	struct	node_st	*np;

	np = (struct node_st *) (pbuf + sizeof (int));
	for (i = 1 ; i < npl ; i++)
		sum = (sum << 1) + np->mark [i];

	return ((sum % modulus) + 1);
	}

bool
FirstProb (pbuf, first)
	char	*pbuf;
	int	first;	{

	index	i;
	struct	node_st	*np;

	*((int *) pbuf) = NODE_SIZE;
	np = (struct node_st *) (pbuf + sizeof (int));

	if (scanf ("%d", &np->mark [1]) != 1)  return (FALSE);

	for (i = 2 ; i < npl ; i++)
		if (scanf ("%d", &np->mark [i]) != 1)
			abort ("bad place value");

	return (TRUE);
	}

bool
Generate (parent, child, first)
	char	*parent, *child;
	int	first;	{

	struct	node_st	*pp, *cp;
	index	i, j, ti;
	bool	enabled;

	pp = (struct node_st *) (parent + sizeof (int));
	if (first) {
		pp->next = 0;
		PrintProb ((char *) pp - sizeof (int));
		}

	for (ti = pp->next ; ti < ntr ; ti++) {
		enabled = TRUE;
		for (i = 0 ; i < NIN ; i++) {
			if ((j = tr [ti].in [i]) < 1)
				break;
			if (pp->mark [j] < tr [ti].need [i]) {
				enabled = FALSE;
				break;
				}
			}

		if (enabled) {
			*((int *) child) = NODE_SIZE;
			cp = (struct node_st *) (child + sizeof (int));
			fire (ti, pp, cp);
			pp->next = ++ti;
			return (TRUE);
			}
		}

	return (FALSE);
	}

void
Combine (parent, child, last)
	char	*parent, *child;
	int	last;	{
	}

int
Compare (node1, node2)
	char	*node1, *node2;	{

	index	i;
	struct	node_st	*np1, *np2;

	np1 = (struct node_st *) (node1 + sizeof (int));
	np2 = (struct node_st *) (node2 + sizeof (int));

	for (i = 1 ; i < npl ; i++) {
		if (np1->mark [i] < np2->mark [i])  return (-1);
		if (np1->mark [i] > np2->mark [i])  return ( 1);
		}

	return (0);
	}

void
PrintProb (pbuf)
	char	*pbuf;	{

	struct	node_st	*np;
	index	i;
	int	sum = 0;

	np = (struct node_st *) (pbuf + sizeof (int));
	printf ("< ");
	for (i = 1 ; i < npl ; i++) {
		printf ("%d ", np->mark [i]);
		sum += np->mark [i];
		}
	printf (">  +%d\n", sum);
	fflush(stdout);
	}

void
PrintAns (pbuf)
	char	*pbuf;	{
	}

/*****************************************************************************
 *
 *	S U P P O R T   R O U T I N E S
 */

int	nin [NTR], nout [NTR];		/* next in/out place for each trans */

index
new_trans (trname)
	char	*trname;	{
	int	i;

	if (ntr >= NTR)
		abort ("too many transitions in Petri net specification");
	if (strlen (trname) > NLEN)
		abort ("transition name too long");

	strcpy (tr [ntr].name, trname);
	nin [ntr] = nout [ntr] = 0;
	for (i = 0 ; i < NIN  ; i++)  tr [ntr].in  [i] = 0;
	for (i = 0 ; i < NOUT ; i++)  tr [ntr].out [i] = 0;
	return (ntr++);
	}

index	add_place ();

void
add_input (plname, ti, need)
	char	*plname;
	index	ti;
	int	need;	{

	if (nin [ti] >= NIN)
		abort ("transition has too many input places in spec");
	if (strlen (plname) > NLEN)
		abort ("place name too long");

	tr [ti].in   [nin [ti]  ] = add_place (plname);
	tr [ti].need [nin [ti]++] = need;
	}

void
add_output (plname, ti, give)
	char	*plname;
	index	ti;
	int	give;	{

	if (nout [ti] >= NOUT)
		abort ("transition has too many output places in spec");
	if (strlen (plname) > NLEN)
		abort ("place name too long");

	tr [ti].out  [nout [ti]  ] = add_place (plname);
	tr [ti].give [nout [ti]++] = give;
	}

index
add_place (plname)
	char	*plname;	{
	index	i;

	for (i = 0 ; i < npl ; i++)
		if (strcmp (plname, pln [i].name) == 0)
			return (i);

	if (npl >= NPL)
		abort ("too many places in Petri net specification");

	strcpy (pln [npl].name, plname);
	return (npl++);
	}

void
fire (ti, pp, cp)
	index	ti;
	struct	node_st	*pp, *cp;	{
	int	i, j;

	for (j = 1 ; j < npl ; j++)
		cp->mark [j] = pp->mark [j];

	for (i = 0 ; i < NIN ; i++)
		if ((j = tr [ti].in [i]) > 0)
			cp->mark [j] -= tr [ti].need [i];
	for (i = 0 ; i < NOUT ; i++)
		if ((j = tr [ti].out [i]) > 0)
			cp->mark [j] += tr [ti].give [i];
	}
