/*  mbrot.c -- actual Mandelbrot set calculations  */

static int cwidth, cheight, nwide, nhigh;	/* cell parameters */
static double xc, yc, side;			/* region parameters */
static double delta, xll, yll;			/* values derived from them */
static int niter;				/* iteration limit */



/*  setup() - set global parameters  */

setup(cw,ch,nw,nh,x,y,s,ni)
int cw, ch, nw, nh, ni;
char *x,*y,*s;
{
    cwidth = cw;
    cheight = ch;
    nwide = nw;
    nhigh = nh;
    niter = ni;
    sscanf(x,"%lf",&xc);
    sscanf(y,"%lf",&yc);
    sscanf(s,"%lf",&side);
    delta = side / (cwidth * nwide);
    xll = xc - (side / 2);
    yll = yc - delta * (nhigh * cheight / 2);
}



/*  calc(i,j,s) - calc cell (i,j) into s  */

calc(i,j,s)
int i, j;
char *s;
{
    int ci, cj;
    double x, y;
    for (cj = cheight; cj--; )  {
	x = xll + delta * i * cwidth;
	y = yll + delta * (j * cheight + cj);
	for (ci = 0; ci < cwidth; ci++)  {
	    *s++ = ptval(x,y,niter);
	    x += delta;
	}
    }
}




/*  ptval(x,y,n) - try up to <n> iterations and return the number needed  */

ptval(x,y,n)
float x, y;
int n;
{
    register float zx, zy, xx, yy, rx, ry;
    register int i;

    rx = x;
    ry = y;
    zx = zy = xx = yy = 0.0;
    for (i = n+1;  --i;  )  {
	zy = (zx + zx) * zy + ry;
	zx = xx - yy + rx;
	xx = zx * zx;
	yy = zy * zy;
	if ((xx + yy) > 4.0)
	    break;
    }
    return n - i;
}
