#  common parameter cracking code and other initialization for srv and srv

# always run with standard umask
umask $VMASK

# make sure search path includes "."
PATH="$PATH:."
export PATH

# set paths to experimental versions by default
sr=$SRDIR/sr/sr
srl=$SRDIR/srl/srl
rts=$SRDIR/rts/srlib.o
srx=$SRDIR/rts/srx
map=$SRDIR/srmap
srm=$SRDIR/srm/srm
srgrind=$SRDIR/srgrind/srgrind
srtex=$SRDIR/srtex/srtex
# and set experimental flags
ec=-e
er=-e

# use necho script if "echo -n" doesn't work.  export for use by scripts.
if [ "X`echo -n YZ`" = "XYZ" ]
    then NECHO='echo -n'
    else NECHO=$SRDIR/srv/necho.sh
    fi
export NECHO

# by default, don't trace in srv
trace=:

# process command options; some of these don't do anything in srvi
for i
do
    case $i in
	-p)			# -p: production versions of everything
	    sr=$SRCMD/sr
	    srl=$SRCMD/srl
	    rts=$SRLIB/srlib.o
	    srx=$SRLIB/srx
	    map=$SRLIB/srmap
	    srm=$SRCMD/srm
	    srgrind=$SRCMD/srgrind
	    srtex=$SRCMD/srtex
	    ec=
	    er=
	    shift;;
	-c)			# -c: production compiler
	    sr=$SRCMD/sr
	    ec=
	    shift;;
	-l)			# -l: production linker
	    srl=$SRCMD/srl
	    shift;;
	-r)			# -r: production runtime system
	    rts=$SRLIB/srlib.o
	    srx=$SRLIB/srx
	    map=$SRLIB/srmap
	    er=
	    shift;;
	-m)			# -m: production makefile maker
	    srm=$SRCMD/srm
	    shift;;
	-g)			# -g: production troff grinder
	    srgrind=$SRCMD/srgrind
	    shift;;
	-t)			# -t: production tex formatter
	    srtex=$SRCMD/srtex
	    shift;;
	-v)			# -v: trace commands as read from script
	    trace=echo
	    shift;;
	-*)
	    echo 1>&2 \
		"usage: $0 [-p] [-c] [-l] [-r] [-m] [-g] [-t] [-x] [-v] dir"
	    exit 1;;
	*)
	    break;;
	esac
    done

# echo SR version number
if [ -r $sr ]
    then
	strings $sr | grep 'SR version'
    fi

# list the versions we will be using
ls -l $sr $srl $rts $srx $srm $srgrind $srtex $map

# make sure they're all accessible
if [ ! '(' -r $sr -a -r $srl -a -r $rts -a -r $srx \
	-a -r $srm -a -r $srgrind -a -r $srtex -a -r $map ')' ]
    then
	echo $0: access tests failed 1>&2
	exit 1
    fi

# disable debugging output
SRXDEBUG=
export SRXDEBUG

# set path for network mapping file
SRMAP=$map
export SRMAP
