/* srfile.c */

#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include "../config.h"
#include "../util.h"
#include "srm.h"

extern char *arg0;	/* for error messages (main.c) */


char *findfile()
/*
 * Return the name of next file named *.sr from current directory.
 */
{
    static DIR *dirp = 0;
    struct direct *d;

    if (!dirp && !(dirp = opendir(".")))
	pexit("current directory");
    while (d = readdir(dirp))
	if (*(d->d_name)!='.' && strtail(d->d_name,SOURCE_SUF))
	    return(salloc(d->d_name));
    closedir(dirp);
    dirp=0;
    return(NULL);
}


nosrfile(file,filetype)
char *file;
char *filetype;
/*
 * Return if file name is non-null and doesn't end in ".sr", otherwise display
 * an error message and exit.  
 */
{
    if (file==0 || *file==0) {
	fprintf(stderr, "%s: bad %s \n", arg0,filetype);
	exit(1);
    }
    if (strtail(file,SOURCE_SUF)) {
	fprintf(stderr, "%s: %s \"%s\" looks like SR source-name\n",
	    arg0,filetype,file);
	exit(1);
    }
}
