%{

/* scan.l */

#include "../util.h"
#include "srm.h"

extern sc_nodep sc_list;	/* list of system component records (main.c) */
extern char *arg0;		/* for error msgs (main.c) */

char *file;			/* name of file being processed */
int line;			/* current line being processed */
f_nodep filep;			/* pointer to file record being processed */

#define GLB_ID SC_GLOBAL	/* GLOBAL ID */
#define SPC_ID SC_ASPEC		/* RESOURCE ID */
#define SPCP_ID SC_SPEC		/* RESOURCE ID with parameters */
#define BDY_ID SC_BODY		/* BODY ID */
#define IMP_ID 5		/* IMPORTed ID */
#define EXT_ID 6		/* EXTENDed ID */

int id_type;			/* one of above */
char *id;			/* tmp pointer to a copy of text of id */
int id_line;			/* line identifier was found on */

%}


%start NORM
%start GLB1
%start RES1
%start RES2
%start BDY1
%start BDY2
%start IMP1
%start IMP2

%%
	id_type=0;		/* beginning state */
	line=1;			/* beginning line number */

\n				line++;				/* newline */
[ \t]				;				/* whitespace */
\#				eat_comment1();			/* comment1 */
\/\*				eat_comment2();			/* comment2 */

\'				{setid(0);eat_strlit('\'');}	/* 'str' */
\"				{setid(0);eat_strlit('\"');} 	/* "str" */

<NORM>global			{setid(GLB_ID);BEGIN GLB1;}
<NORM>resource			{setid(SPC_ID);BEGIN RES1;}
<NORM>body			{setid(BDY_ID);BEGIN BDY1;}
<NORM>import			{setid(IMP_ID);BEGIN IMP1;}
<NORM>extend			{setid(EXT_ID);BEGIN IMP1;}
<NORM>[a-zA-Z][a-zA-Z0-9\_]*	;				/* garbage */

<RES1>[a-zA-Z][a-zA-Z0-9\_]*	{id=salloc(yytext);id_line=line;BEGIN RES2;}
<RES1>.				{unput(*yytext);setid(0);BEGIN NORM;}

<RES2>\(			{id_type=SPCP_ID;addid(id,id_line);BEGIN NORM;}
<RES2>.				{unput(*yytext);addid(id,id_line);BEGIN NORM;}

<BDY1>[a-zA-Z][a-zA-Z0-9\_]*	{id=salloc(yytext);id_line=line;BEGIN BDY2;}
<BDY1>.				{unput(*yytext);setid(0);BEGIN NORM;}

<BDY2>\(			eat_params();
<BDY2>separate			{id_type=0;free(id);BEGIN NORM;}
<BDY2>.				{unput(*yytext);addid(id,id_line);BEGIN NORM;}

<IMP1>[a-zA-Z][a-zA-Z0-9\_]*	{addimp(salloc(yytext),line);BEGIN IMP2;}
<IMP1>.				{unput(*yytext);setid(0);BEGIN NORM;}

<IMP2>\,			{BEGIN IMP1;}
<IMP2>.				{unput(*yytext);id_type=0;BEGIN NORM;}

<GLB1>[a-zA-Z][a-zA-Z0-9\_]*	{addid(salloc(yytext),line);BEGIN NORM;}
<GLB1>.				{unput(*yytext);setid(0);BEGIN NORM;}

.				;				/* garbage */

%%


lexsr(srfile)
char *srfile;
/*
 * Invoke yylex() in the mode to process an sr source file. Puts the
 * list of resource nodes in the global node list 'sc_list'
 */
{
    static struct f_node zfnode;	/* all zeros for initialization */

    filep=(f_nodep)alloc(sizeof(struct f_node));
    *filep=zfnode;
    filep->file=file=srfile;

    BEGIN NORM;
    yylex();
}

eat_comment1()
/*
 * skip a # comment
 */
{
    register int c;

    while (c = input())
	if (c=='\n') {
	    line++;
	    break;
	}
}

eat_comment2()
/*
 * skip a block comment
 */
{
    register int c;

    c = input();
    for (;;) {
	switch (c)  {
	    case 0:
		fprintf(stderr,
		    "%s: \"%s\" line %d: unterminated comment\n",
		    arg0,file,line);
		exit(1);
	    case '\n':
		line++;
		c = input();
		continue;
	    case '/':
		c = input();
		if (c == '*') {
		    eat_comment2();
		    c = input();
		}
		continue;
	    case '*':
		c = input();
		if (c == '/')
		    return;
		continue;
	    default:
		c = input();
		continue;
	}
    }
}

eat_strlit(delim)
char delim;
/*
 *  skip string literal ("string" or 'string')
 *  (yylook can overflow the buffer if this is done with lex patterns) 
 */
{
    register int  c;

    c = input();
    for (;c != delim;) {
	switch (c) {
	    case 0:
		fprintf(stderr,
		    "%s: \"%s\" line %d: unterminated string\n",
		    arg0,file,line);
		exit(1);
	    case '\n':
		line++;
		c = input();
		continue;
	    case '\\':
		if ((c = input()) == '\n')
		    line++;
		c = input();
		continue;
	    default:
		c = input();
		continue;
	}
    }
}

eat_params()
/*
 * skip a paramter declaration
 */
{
    register int c;

    c = input();
    for (;;) {
	switch (c)  {
	    case 0:
		fprintf(stderr,
		    "%s: \"%s\" line %d: unterminated parameter declaration\n",
		    arg0,file,line);
		exit(1);
	    case '\n':
		line++;
		c = input();
		continue;
	    case '(':
		eat_params();
		c = input();
		continue;
	    case '#':
		eat_comment1();
		c = input();
		continue;
	    case '/':
		c = input();
		if (c == '*') {
		    eat_comment2();
		    c = input();
		}
		continue;
	    case '\'':
		eat_strlit('\'');
		c = input();
		continue;
	    case '\"':
		eat_strlit('\"');
		c = input();
		continue;
	    case ')':
		return;
	    default:
		c = input();
		continue;
	}
    }
}

setid(type)
int type;
/*
 * Set 'id_type' to describe the next id to be read in.  If it's
 * non-zero then we missed an id (error). 
 */
{
    if (id_type!=0) {
	fprintf(stderr,
	    "%s: \"%s\" line %d: expected identifier\n",
	    arg0,file,line);
	exit(1);
    }
    id_type=type;
}

addid(id,id_line)
char *id;
int id_line;
/*
 * Create an sc_node for the id in 'id'.
 */
{
    static struct sc_node zscnode;	/* all zeros for initialization */
    register sc_nodep sct1;

    sct1=(sc_nodep)alloc(sizeof(struct sc_node));
    *sct1=zscnode;
    sct1->id=id;
    sct1->type=id_type;
    sct1->file=filep;
    sct1->line=id_line;
    sct1->next=sc_list;
    sc_list=sct1;

    id_type=0;
}

addimp(id,id_line)
char *id;
int id_line;
/*
 * add the imported/extended id in 'id' to the current system component's
 * import or extend list.
 */
{
    register id_nodep idt1;

    if (sc_list) switch (id_type) {
	case IMP_ID:
	    if (strcmp(id,sc_list->id)==0) {
		fprintf(stderr,
		    "%s: \"%s\" line %d: \"%s\" imports itself\n",
		    arg0,file,id_line,id);
		exit(1);
	    }
	    idt1=(id_nodep)alloc(sizeof(struct id_node));
	    idt1->id=id;
	    idt1->line=id_line;
	    idt1->next=sc_list->imp;
	    sc_list->imp=idt1;
	    break;
	case EXT_ID:
	    if (strcmp(id,sc_list->id)==0) {
		fprintf(stderr,
		    "%s: \"%s\" line %d: \"%s\" extends itself\n",
		    arg0,file,id_line,id);
		exit(1);
	    }
	    idt1=(id_nodep)alloc(sizeof(struct id_node));
	    idt1->id=id;
	    idt1->line=id_line;
	    idt1->next=sc_list->ext;
	    sc_list->ext=idt1;
	    break;
    }
}
