/*  gen.c -- generate initialization file and link script  */


#include "globals.h"
#include "funcs.h"
#include "../config.h"
#include "../paths.h"

static char *exe_tail;



void
gen_config () {
    FILE *fp;
    resp res;
    buffer temp;
    char *args[MAX_RES_DEF+10];
    char **argp;
    char *sep;
    int status;

    if (exe_tail = strrchr(exe_file,'/'))	/* strip path */
	exe_tail++;
    else
	exe_tail = exe_file;

    sprintf (temp, "%s/%s.c", Interfaces, exe_tail);
    fp = mustopen (temp, "w");

    fprintf (fp, "/* srl info for %s */\n\n", exe_tail);
    fprintf (fp, "static char SR_version[] = \n\t\"%s\";\n\n", version);

    fprintf (fp, "int sr_max_co_stmts = %d;\n", max_co_stmts);
    fprintf (fp, "int sr_max_classes = %d;\n", max_classes);
    fprintf (fp, "int sr_max_loops = %d;\n", max_loops);
    fprintf (fp, "int sr_max_operations = %d;\n", max_operations);
    fprintf (fp, "int sr_max_processes = %d;\n", max_processes);
    fprintf (fp, "int sr_max_rmt_reqs = %d;\n", max_rmt_reqs);
    fprintf (fp, "int sr_max_resources = %d;\n", max_resources);
    fprintf (fp, "int sr_max_semaphores = %d;\n", max_semaphores);
    
    fprintf (fp, "int sr_stack_size = %d;\n", stack_size);
    fprintf (fp, "int sr_trace_flag = %d;\n", trace_flag);

    fprintf (fp, "char sr_exec_path[] = \"");
    if (exper || sizeof (SRLIB) <= 1)
	fprintf (fp, "%s/rts/%s", SRDIR, RUNTIME_EXEC);
    else
	fprintf (fp, "%s/%s", SRLIB, RUNTIME_EXEC);
    fprintf (fp, "\";\n\n");

    sep = "int ";
    for (res = res_list ; res ; res = res->next)  {
	fprintf (fp, "%sRN%s = %d", sep, res->name, res->patnum);
	sep = ", ";
    }
    fprintf (fp, ";\n");

    fprintf (fp, "extern int ");
    for (res = res_list ; res ; ) {
	fprintf (fp, "I%s()", res->name);
	if (res->final)
	    fprintf (fp, ", F%s()", res->name);
	if (res = res->next)
	    fprintf (fp, ", ");
    }

    fprintf (fp, ";\nint (*sr_rpat[])() = { ");
    for (res = res_list ; res ; res = res->next)  {
	fprintf (fp, "I%s, ", res->name);
	if (res->final)
	    fprintf (fp, "F%s, ", res->name);
	else
	    fprintf (fp, "0, ");
    }

    fprintf (fp, "};\n");
    fclose (fp);

    /* compile (in the Interfaces directory) the configuration file */
    sprintf (temp, "%s.c", exe_tail);
    argp = args;
    *argp++ = "cc";
    if (dbx)
	*argp++ = "-g";
    *argp++ = "-c";
    *argp++ = temp;
    *argp++ = 0;
    status = spawn (CCPATH, args, Interfaces, (char *) 0, (char *) 0);
    if (status != 0)
	mexit ("can't compile VM init file");
}



/*
 *  Link the configuration with resources and rts.  DOES NOT RETURN.
 */
void
gen_exe () {
    resp res;
    objp obj;
    buffer rtsobj, figfile, temp;
    char *args[MAX_RES_DEF+10];
    char **argp;

    /* Try to unlink the old exe file; otherwise, ld just overwrites it.
     * In an NFS environment, such an "update" isn't always seen immediately
     * on other machines, and a mixture of old and new can be executed!
     * No problem, however, if a new version of the file is recreated. */
    unlink(exe_file);

    if (lib_file)
	strcpy (rtsobj, lib_file);
    else if (exper || sizeof (SRLIB) <= 1)
	sprintf (rtsobj, "%s/rts/%s", SRDIR, RUNTIME_OBJ);
    else
	sprintf (rtsobj, "%s/%s", SRLIB, RUNTIME_OBJ);
    
    sprintf (figfile, "%s/%s.o", Interfaces, exe_tail);
    argp = args;
    *argp++ = "cc";
    *argp++ = dbx ? "-g" : "-s";
    *argp++ = "-o";
    *argp++ = exe_file;
    *argp++ = figfile;
    for (res = res_list ; res ; res = res->next)  {
	sprintf (temp, "%s.o", res->name);
	*argp++ = salloc (temp);
    }
    *argp++ = rtsobj;
    for (obj = obj_list ; obj ; obj = obj->next)
	*argp++ = obj->object;
    *argp++ = 0;
    doexec (CCPATH, args);
    exit (0);
}
