/*  check.c -- check object code  */


#include <sys/types.h>
#include <sys/stat.h>
#include "globals.h"
#include "funcs.h"
#include "../config.h"



int not_all_current = 0;	/* > 0 iff not all resources current */



/*  Get modification time of a file.  */

static time_t
get_mtime(fn,resname,which)
char *fn, *resname, *which;
{
    struct stat status;

    if (stat (fn, &status) != 0) {
	buffer mesg;
	sprintf (mesg, "can't find %s file (%s) for %s",
			which, fn, resname);
	srl_error (mesg);
	return (0);
    }
    return (status.st_mtime);
}



/*  Issue error message for file out of date.  */

static void
not_current(resname,which)
char *resname, *which;
{
    buffer mesg;

    sprintf (mesg, "%s for %s modified since last compile", which, resname);
    srl_warn (mesg);
    not_all_current++;
}



/*  Call make_obj_name() and up_to_date() on each resource.  */

void
check_object () {
    resp res;

    for (res = res_list ; res ; res = res->next) {
	make_obj_name (res);
	up_to_date (res);
    }
}



/*  Make the name(s) of a resources' object file(s) given the name of the source
 *  file.  */

void
make_obj_name (res)
resp res;
{
    char *sp;
    int dot, slash;

    /* make sure source file suffix is correct */
    sp = res->source + (dot = strlen (res->source) - strlen(SOURCE_SUF));
    if (dot <= 0 || strcmp (sp, SOURCE_SUF))
	mexit ("source file name in body file has bad suffix");

    /* get name of directory containing source file */
    for (sp-- ; sp >= res->source && *sp != '/' ; sp--) ;
    if ((slash = sp - res->source) < 0)
	mexit ("source file name in body file is missing a '/'");

    res->object = alloc (slash + strlen (res->name) + 4);
    strncpy (res->object, res->source, slash+1);
    res->object [slash+1] = '\0';
    strcat (res->object, res->name);
    strcat (res->object, ".o");

}



/* Make sure source code for a resource hasn't been modified since the last
 * time it was compiled.  */

void
up_to_date (res)
resp res;
{
    time_t body_mtime, obj_mtime;
    time_t inter_mtime, spec_mtime;
    buffer inter_path, spec_source;
    FILE *inter;

    sprintf (inter_path, "%s/%s%s", Interfaces, res->name, INTER_SUF);
    inter_mtime = get_mtime (inter_path, res->name, INTER_SUF);
    if (!inter_mtime)
	return;
    inter = mustopen (inter_path, "r");

    if (fscanf (inter, "# %100s", spec_source) != 1) {
	/* 100 == sizeof buffer */
	buffer mesg;
	sprintf (mesg, "can't read spec file name for %s", res->name);
	srl_error (mesg);
	return;
    }

    fclose (inter);
    if (!(body_mtime = get_mtime (res->source, res->name, "body source")))
	return;
    if (!(spec_mtime = get_mtime (spec_source, res->name, "spec source")))
	return;

    obj_mtime = get_mtime (res->object, res->name, "object");
    if (!obj_mtime)
	return;
    if (do_time_check && body_mtime > obj_mtime)
	not_current (res->name, "body");
    if (do_time_check && spec_mtime > obj_mtime)
	not_current (res->name, "spec");

}



/*  Make sure the main resource exists and has no parameters.  */

void
check_main () {
    buffer mesg;

    if (!res_list)
	mexit ("no main resource");
    else if (res_list->params != 0)  {
	sprintf (mesg, "main resource (%s) has parameters",
	    res_list->name);
	srl_error (mesg);
    }
}
