/*  bodies.c -- read Bodies file  */


#include "globals.h"
#include "funcs.h"
#include "../config.h"

static resp body_list;	/* list of known bodies */



/* Attempt to read the body file for a named resource.  Give an error if
 * it's been requested before.  Copy it and return pointer to duplicate.
 */

resp 
res_search (name)
char *name;
{
    FILE *in;
    int bparams, bfinal;
    buffer bodyfile, bfile, mesg;
    resp res, dup;

    for (res=body_list;res!=NULL;res=res->next)
	if (strcmp(name,res->name)==0) {
	    sprintf (mesg,"resource duplicated (%s)",name);
	    srl_error (mesg);
	}

    sprintf(bodyfile,"%s/%s%s",Interfaces,name,BODY_SUF);

    if ((in=fopen(bodyfile,"r"))==NULL)
	return(NULL);

    if (fscanf(in,"%100s %d %d\n",bfile,&bparams,&bfinal)!=3) {
	sprintf (mesg,"bad body file (%s)",bodyfile);
	mexit(mesg);
    }

    fclose(in);

    /* make an entry for it and link it in */
    res = new(struct res_st);
    res->name   = salloc(name);
    res->source = salloc(bfile);
    res->params = bparams;
    res->final  = bfinal;
    res->next = body_list;
    body_list = res;
    
    dup = new(struct res_st);
    *dup = *res;
    return(dup);
}
