/* tokmacs.h - macros for classifying tokens */

struct tkatt {
	unsigned char reserved;		/* reserved word? */
	unsigned char lchild, rchild;	/* types of subnodes */
	unsigned char precedence;	/* precedence (>0 iff binary opr) */
};

extern struct tkatt token_atts[];

#define RESERVED_TOK		0x20

#define PRECEDENCE(tok)	(token_atts[(int)tok].precedence)
#define IS_RESERVED(tok) (token_atts[(int)tok].reserved)

#define N_NIL 0
#define N_NODE 1
#define N_SYM 2
#define N_CON 3

#define LEFT_CHILD(tok) (token_atts[(int)(tok)].lchild)
#define RIGHT_CHILD(tok) (token_atts[(int)(tok)].rchild)
