/*  Statements.  */

#include <stdio.h>
#include "sr.h"
#include "funcs.h"
#include "globals.h"

static void create_stmt(), id_stmt(), destroy_stmt(), return_stmt();
static void reply_stmt(), inc_dec();



/* follow set used to get to start of next statement;
 * this stuff is verrrrry iffy.
 */
static Token fl_stmt[] = {
		TK_SEMICOLON,
	/* start of declaration. */
		TK_CONST, TK_TYPE, TK_VAR, TK_OP, TK_SEM,
		TK_EXTERNAL, TK_OPTYPE,
	/* start of statements, and close of statements. */
		TK_SKIP, TK_IF, TK_FI, TK_DO, TK_OD,
		TK_FA, TK_AF, TK_EXIT, TK_NEXT, TK_DESTROY,
		TK_CALL, TK_SEND, TK_V, TK_IN, TK_RECEIVE, TK_P,
		TK_CO, TK_OC, TK_RETURN,
		TK_REPLY,
	/* end of proc and start of procs in case end is missing. */
		TK_END,
		TK_INITIAL, TK_FINAL, TK_PROC, TK_PROCESS,
		TK_NOTATOKEN };

				/* 4. Statements */
/* note that declarations and statements are allowed to appear
 * in any order.
 */
void
statement()
{
	Token mytok;

	mytok = get_token();
	switch (mytok) {

	    /* declarations. */
	case TK_CONST:
	    var_decl(K_CONST);
	    break;
	case TK_TYPE:
	    type_declr();
	    break;
	case TK_VAR:
	    var_decl(K_VAR);
	    break;
	case TK_EXTERNAL:
	    FATAL("external declaration not at resource level");
	    /*NOBREAK*/
	case TK_OP:
	case TK_SEM:
	    op_declr(mytok);
	    break;
	case TK_OPTYPE:
	    optype_declr();
	    break;
	case TK_IMPORT:
	    import_declr();
	    break;

	    /* statements. */
	case TK_SKIP:
	    break;
	case TK_IF:
	    if_stmt();
	    break;
	case TK_DO:
	    do_stmt();
	    break;
	case TK_FA:
	    for_all_stmt();
	    break;
	case TK_EXIT:
	    exit_stmt();
	    break;
	case TK_NEXT:
	    next_stmt();
	    break;
	case TK_IDENTIFIER:
	    id_stmt();
	    break;
	case TK_DESTROY:
	    destroy_stmt();
	    break;
	case TK_V:
	    sema_v_stmt();
	    break;
	case TK_CALL:
	case TK_SEND:
	    call_send_stmt(mytok);
	    break;
	case TK_IN:
	    in_stmt();
	    break;
	case TK_RECEIVE:
	case TK_P:
	    receive_stmt(mytok);
	    break;
	case TK_CO:
	    co_stmt();
	    break;
	case TK_RETURN:
	    return_stmt();
	    break;
	case TK_STOP:
	    stop_stmt();
	    break;
	case TK_REPLY:
	    reply_stmt();
	    break;
	case TK_SEMICOLON:
	    /* separate case just to give better error message. */
	    WARN("statement shouldn't start with semicolon");
	    break;
	default:
	    errmsg(E_FATAL,"invalid token '%s' at start of statement",yytext);
	    find_follow(fl_stmt);
	    break;
	}
}

/* statement that starts with an identifier. */
static void
id_stmt(){
	Nodeptr n, e;
	Symptr sig; /* signature. */

	/* get the first denotation.
	 * it determines the kind of statement.
	 * look for: create, (implicit) call, inc/dec.
	 * default is assignment.
	 */
	putback();
	if ((n = denotation(TK_CALL)) == NULLNODE) {
		ERROR(E_FATAL+1,tk_str);
		return;
	}
	sig = n->e_sig;
    if (dbflags['S'])
	printf("in id_stmt, sig->s_type: %s, sig->s_tdef: %x, ->s_type: %s\n",
    typetos(sig->s_type), sig->s_tdef, typetos(sig->s_tdef->s_type));
	if (sig->s_type == T_CAP && sig->s_tdef
		&& sig->s_tdef->s_type == T_SPEC) {
		/* look for create statement.
		 * otherwise do assignment, or fall through to assignment,
		 * depending on how much lookahead we used.
		 */
			if (get_token() == TK_ASSIGN) {
				if (get_token() == TK_CREATE) {
					create_stmt(n);
					return;
				}
				else {
					putback();
					assign_rhs(TK_ASSIGN,n);
					return;
				}
			}
			else {
				putback();
			}
	}
	else if (n->e_op == TK_CALL) {
		call_send(n);
		return;
	}

	get_token();
	if (tok == TK_INCREMENT || tok == TK_DECREMENT) {
		inc_dec(n,tok);
		return;
	}

	if (tok == TK_SWAP) {
		if ((e = expr()) != NULLNODE) {
			emit(I_EXPR,bnode(TK_SWAP,n,e),NOLAB);
		}
		else
			FATAL("bad expression on right hand side of swap");
		return;
	}

	putback();

	/* it's an assignment statement. */
	mustbe(TK_ASSIGN,":=");
	assign_rhs(TK_ASSIGN,n);
}

static void
inc_dec(n,mytok)
Nodeptr n;
Token mytok;
{
	emit(I_EXPR,bnode(mytok,n,NULLNODE),NOLAB);
}

static void
create_stmt(lhs)
Nodeptr lhs; /* left hand side of assignment. */
{
	Symptr sym;
	Nodeptr arglist, on, n, rhs;

	if (!maybe(TK_IDENTIFIER)) {
		FATAL("missing id on create statement");
		return;
	}
	if ((sym = st_lookup(tk_str)) == NULLSYM) {
		errmsg(E_FATAL,"bad id on create statement: %s",yytext);
		return;
	}

	mustbe(TK_LEFTPAREN,"(");
	arglist = farg();
	if (maybe(TK_ON))
		n = expr();
	else
		n = NULLNODE;

	if (sym->s_kind == K_VM) {	/* create vm() [on iexpr] */
		if (arglist != NULLNODE)	
			FATAL("no args allowed on 'create vm()'");
		rhs = snode(TK_CREVM,sym,n);
	} else {
		on = bnode(TK_ON, n, arglist);
		rhs = bnode(TK_CREATE,idnode(sym),on);
	}
	emit(I_EXPR,bnode(TK_ASSIGN,lhs,rhs),NOLAB);
}

static void
destroy_stmt()
{
	Nodeptr e;

	if ((e = denotation(TK_CALL)) == NULLNODE) {
		FATAL("bad denotation on destroy");
		return;
	}
	emit(I_EXPR,bnode(TK_DESTROY,e,NULLNODE),NOLAB);
}


/* parse the right hand side of an assignment statement,
 * or initialization in a declaration.
 * then, make a TK_ASSIGN or TK_CONST node from the lhs and the rhs.
 */
void
assign_rhs(op,lhs)
Token op;
Nodeptr lhs;
{
	Nodeptr rhs;

	assert(lhs != NULLNODE);
	if (lhs->e_sig->s_kind == K_CONST && op != TK_CONST)
	    FATAL("can't change the value of a constant");
	else if ((rhs = expr()) != NULLNODE)
	    emit(I_EXPR,bnode(op,lhs,rhs),NOLAB);
	else
	    FATAL("bad expression on right hand side of assignment");
}

/* note: reply make sense at outer level of initial/final.
 * don't emit for replies to ops that have {send} restriction.
 * for [call,send}, though, do emit; for such, code generator
 * generates code to test invocation block.
 */
static void
reply_stmt()
{
    Symptr op_sym;

    assert (reply_block != NULLSYM && reply_block->s_kind == K_BLOCK);

    switch (reply_block->s_type) {
	case T_INIT:
	case T_FINAL:
	    /* do nothing. */
	    break;
	case T_PROC:
	case T_INPUT:
	    op_sym = reply_block->s_tdef;
	    assert (op_sym != NULLSYM);
	    switch (op_sym->s_restrict) {
		case R_CALL:
		case R_CALLSEND:
		    /* continue. */
		    break;
		case R_SEND:
		    errmsg(E_WARN,
			"reply within {send} operation has no effect: %s",
			op_sym->s_name);
		    return;
		default:
		    boom("bad s_restrict in reply_stmt");
		    break;
	    }
	    op_sym->s_reply = TRUE;
	    break;
	default:
	    boom("bad reply_block->s_type in reply_stmt");
	    /*NOTREACHED*/
	    break;
    }
    emit(I_REPLY, idnode(reply_block), NOLAB);
}

/* note: return is allowed in initial/final too.
 */
static void
return_stmt()
{
	assert (return_label != NOLAB);
	emit(I_BRANCH, NULLNODE, return_label);
	unreachable = TRUE;
}
