/*  srgen.h -- definitions used in C code generated by SR compiler
 *
 *  proc parameters:
 * 	char *rp	resource parameter block address
 *	char *rv	resource variable block address
 *	char *pb	proc parameter block address
 *	int  wc		who called?  (nonzero if called from RTS)
 *
 *  proc locals are in the char array lv, cast as necessary.
 *
 *  The macros generally assume that no parameter will be an unparenthesized
 *  binary expression; arguments are not protected by adding extra parens.
 */

/* Local variables, as integers and as addresses */
#define LO(n) *(int*)(lv+n)
#define LA(n) *(char**)(lv+n)

/* Resource variables, as integers and as addresses */
#define RE(n) *(int*)(rv+n)
#define RA(n) *(int*)(rv+n)

/* integer or address value at a given address */
#define I(a) *(int*)(a)
#define A(a) *(char**)(a)

/* round up to multiple of wordsize */
#define R(v) ((v+3)&-4)

/* string constant */
#define string(x,s) static struct{int l;char c[sizeof(s)];}x={sizeof(s)-1,s}


/* runtime environment */

extern struct ocap_st sr_no_ocap, sr_nu_ocap;
extern struct rcap_st sr_no_rcap, sr_nu_rcap;
extern FILE *sr_stdin, *sr_stdout, *sr_stderr;
extern int sr_my_machine, sr_my_vm, sr_no_vmcap, sr_nu_vmcap;
extern int sr_rem_loops;

extern char *sr_alloc_rv();
extern char *sr_cat();
extern char *sr_chk_myinv();
extern char *sr_clone();
extern char *sr_co_wait();
extern char *sr_gen_alloc();
extern char *sr_get_anyinv();
extern char *sr_get_myinv();
extern char *sr_invoke();
extern char *sr_make_class();
extern char *sr_make_semop();
extern char *sr_new();
extern char *sr_receive();
extern char *sr_reply();
extern char *sr_talloc();
