%e 800
%p 2100
%n 300
%k 100
%a 700
%o 1000		/* HP-UX needs 1000 */

%{

#include "sr.h"
#include "funcs.h"
#include "globals.h"
#include "../srsys.h"

#define RETURN(v) return((int)v)  /* cast Token to int for yylex return*/

/* hex to integer mapping (use low 5 bits of ascii char as subscript) */
static unsigned xci[] = 
    {0,10,11,12,13,14,15,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9};


static Token dobool(), doid(), donum(), dosrfile(), chrlit(), strlit();
static int escape();
static void comment();


/********************************  NOTE  *******************************/

/*	when adding or changing keywords, also update
	../srgrind/srgrind.sh and ../srtex/scan.l	*/

/***********************************************************************/

%}
%%

EOF		{ yynode = numnode(EOF); RETURN (TK_NUMBER); }
P		RETURN (TK_P);
V		RETURN (TK_V);
af		RETURN (TK_AF);
and		RETURN (TK_AND);
any		RETURN (TK_ANY);
body		RETURN (TK_BODY);
bool		RETURN (TK_BOOL);
by		RETURN (TK_BY);
call		RETURN (TK_CALL);
cap		RETURN (TK_CAP);
char		RETURN (TK_CHAR);
co		RETURN (TK_CO);
const		RETURN (TK_CONST);
create		RETURN (TK_CREATE);
destroy		RETURN (TK_DESTROY);
do		RETURN (TK_DO);
downto		RETURN (TK_DOWNTO);
else		RETURN (TK_ELSE);
end		RETURN (TK_END);
enum		RETURN (TK_ENUM);
exit		RETURN (TK_EXIT);
extend		RETURN (TK_EXTEND);
external	RETURN (TK_EXTERNAL);
fa		RETURN (TK_FA);
false		RETURN (dobool(FALSE));
fi		RETURN (TK_FI);
file		RETURN (TK_FILE);
final		RETURN (TK_FINAL);
global		RETURN (TK_GLOBAL);
if		RETURN (TK_IF);
import		RETURN (TK_IMPORT);
in		RETURN (TK_IN);
initial		RETURN (TK_INITIAL);
int		RETURN (TK_INT);
new		RETURN (TK_NEW);
next		RETURN (TK_NEXT);
ni		RETURN (TK_NI);
noop		RETURN (TK_NOOP);
not		RETURN (TK_NOT);
null		RETURN (TK_NULL);
oc		RETURN (TK_OC);
od		RETURN (TK_OD);
on		RETURN (TK_ON);
op		RETURN (TK_OP);
optype		RETURN (TK_OPTYPE);
or		RETURN (TK_OR);
proc		RETURN (TK_PROC);
process		RETURN (TK_PROCESS);
ptr		RETURN (TK_PTR);
rec		RETURN (TK_REC);
receive		RETURN (TK_RECEIVE);
ref		RETURN (TK_REF);
reply		RETURN (TK_REPLY);
res		RETURN (TK_RES);
resource	RETURN (TK_RESOURCE);
return		RETURN (TK_RETURN);
returns		RETURN (TK_RETURNS);
sem		RETURN (TK_SEM);
send		RETURN (TK_SEND);
separate	RETURN (TK_SEPARATE);
skip		RETURN (TK_SKIP);
st		RETURN (TK_SUCHTHAT);
stderr		RETURN (dosrfile(TK_STDERR));
stdin		RETURN (dosrfile(TK_STDIN));
stdout		RETURN (dosrfile(TK_STDOUT));
stop		RETURN (TK_STOP);	
string		RETURN (TK_STRING);	
to		RETURN (TK_TO);
true		RETURN (dobool(TRUE));
type		RETURN (TK_TYPE);
val		RETURN (TK_VAL);
var		RETURN (TK_VAR);
xor		RETURN (TK_XOR);

","		RETURN (TK_COMMA);
";"		RETURN (TK_SEMICOLON);
":"		RETURN (TK_COLON);
"="		RETURN (TK_EQ);
"++"		RETURN (TK_INCREMENT);
"+"		RETURN (TK_PLUS);
"--"		RETURN (TK_DECREMENT);
"-"		RETURN (TK_MINUS);
"*"		RETURN (TK_STAR);
"/"		RETURN (TK_DIV);
"%"		RETURN (TK_MOD);
"("		RETURN (TK_LEFTPAREN);
")"		RETURN (TK_RIGHTPAREN);
"->"		RETURN (TK_ARROW);
"[]"		RETURN (TK_SQUARE);
":="		RETURN (TK_ASSIGN);
":=:"		RETURN (TK_SWAP);
"["		RETURN (TK_LEFTBKET);
"]"		RETURN (TK_RIGHTBKET);
">="		RETURN (TK_GE);
"<="		RETURN (TK_LE);
">"		RETURN (TK_GT);
"<"		RETURN (TK_LT);
"!="		RETURN (TK_NE);
"~="		RETURN (TK_NE);
"|"		RETURN (TK_OR);
"&"		RETURN (TK_AND);
"."		RETURN (TK_PERIOD);
"~"		RETURN (TK_NOT);
"@"		RETURN (TK_ADDR);
"^"		RETURN (TK_HAT);
"||"		RETURN (TK_CONCAT);
"{"		RETURN (TK_LEFTBCE);
"}"		RETURN (TK_RIGHTBCE);
"?"		RETURN (TK_QUESTION);
"//"		RETURN (TK_PARALLEL);
">>"		RETURN (TK_RSHIFT);
"<<"		RETURN (TK_LSHIFT);

[A-Za-z][A-Za-z0-9_]*   RETURN (doid());	/* identifier */
[0-7]+[qQ]		RETURN (donum(8));	/* base 8 integer */
[0-9]+			RETURN (donum(10));	/* base 10 integer */
[0-9][0-9a-fA-F]*[Xx]	RETURN (donum(16));	/* base 16 integer */
\'                      RETURN (chrlit());	/* character literal*/
\"                      RETURN (strlit());	/* string literal */
"/*"			comment();		/* block comment */
"*/"			FATAL("comment terminator outside comment");
#.*	                  ;			/* line comment */
[ \t]                     ;			/* whitespace */
\n                      lineno++;		/* newline */
.                       errmsg(E_FATAL,"illegal character '%s'",yytext);

%%

#include <stdio.h>
#include <ctype.h>
#include "../util.h"



/* sets tk_str to the string table entry for identifiers. */
static Token
doid()
{
    tk_str = nt_lookup(yytext,TRUE);
    return (TK_IDENTIFIER);
}


/* sets yynode for boolean constants. */
static Token
dobool(value)
Bool value;
{
    union e_lu lu;
    lu.e_int = value;
    yynode = make_node(TK_BOOLEAN, lu, NULLNODE);
    return (TK_BOOLEAN);
}


/* sets yynode for SRfile. */
static Token
dosrfile(mytok)
Token mytok;
{
    union e_lu f;

    assert (mytok==TK_STDERR || mytok==TK_STDIN || mytok==TK_STDOUT);
    f.e_file =	(mytok == TK_STDERR) ? F_STDERR :
		(mytok == TK_STDIN)  ? F_STDIN : F_STDOUT ;
    yynode = make_node(TK_FILE_CONST, f, NULLNODE);
    return (TK_FILE_CONST);
}


/* sets yynode for integer. */
static Token
donum(base)
{
    YYCHAR *p, *q;
    int n;

    p = yytext;				/* string pointer */
    q = yytext + yyleng;		/* end+1 of string */
    if (base != 10)			/* chop "q" or "x" if not base 10 */
	q--;
    n = 0;
    while (p < q)			/* process each digit in turn */
	n = base * n + xci [*p++ & 037];
    yynode = numnode(n);
    return (TK_NUMBER);
}


/* sets yynode for character literal ('c') */
static Token
chrlit()
{
    union e_lu lu;
    int c;

    c = input();
	if (c == '\n')  lineno++;
    if (c == '\\')  c = escape();
    lu.e_int = c;
    yynode = make_node(TK_CHRLIT, lu, NULLNODE);

    c = input();
    if (c != '\'') {
	FATAL("character literal contains multiple characters");
	while (c != '\'' && c != '\n' && c != 0)
	    c = input();
	if (c == '\n')  lineno++;
    }

    return (TK_CHRLIT);
}


/*  scans string literal ("string")
 *  (yylook can overflow the buffer if this is done with lex patterns)
 */
static Token
strlit()
{
    int  i, noise;
    int  c;
    union e_lu e;

    noise = 0;
    i = 1;
    for (c = input(); c != 0 && c != '"'; c = input()) {
	if (c == '\n')  lineno++;
	if (c == '\\')  c = escape();
	yytext[i] = c;
	if (i < YYLMAX - 1)
	    i++;
	else if (noise == 0) {
	    strcpy(yytext+30,"...");
	    errmsg(E_FATAL,"string too long: %s",yytext);
	    i = strlen(yytext);
	    noise = 1;
	}
    }
    /* drop last quote. */
    yytext[i] = '\0';
    /* put string ignoring last quote in string space. */
    e.e_char = (Strptr)alloc(sizeof(Str)+i);
    e.e_char->str_len = i-1;
    memcpy(e.e_char->str_data, yytext+1, i);
    yynode = make_node(TK_STRLIT, e, NULLNODE);
    return (TK_STRLIT);
}


/* returns escaped character */
static int
escape()
{
    int ntok;
    unsigned bitp;

    switch (ntok = input()) {
    case 'a'  :     return ('\007');		/* alert */
    case 'b'  :     return ('\b');		/* backspace */
    case 'e'  :     return ('\033');		/* escape */
    case 'f'  :     return ('\f');		/* form feed */
    case 'n'  :     return ('\n');		/* newline */
    case 'r'  :     return ('\r');		/* return */
    case 't'  :     return ('\t');		/* tab */
    case 'v'  :     return ('\013');		/* vertical tab */
    case '\n' :	lineno++;  return ('\n');	/* newline */
    case 'x':
	ntok = input();
	if (isdigit(ntok) || (ntok>='a'&&ntok<='f') || (ntok>='A'&&ntok<='F')) {
	    bitp = xci [ntok & 037];
	    ntok = input();
	    if (isdigit(ntok)||(ntok>='a'&&ntok<='f')||(ntok>='A'&&ntok<='F')) {
		return ((bitp << 4) | xci [ntok & 037]);
	    } else {
		unput(ntok);
		return (bitp);
	    }
	} else {
	    unput(ntok);
	    return (0);
	}
    default:
	if ('0' <= ntok && ntok <= '7') {
	    bitp = ntok - '0';
	    if ((ntok = input()) >= '0' && ntok <= '7') {
		bitp = (bitp << 3) | (ntok - '0');
		if ((ntok = input()) >= '0' && ntok <= '7')
		    bitp = (bitp << 3) | (ntok - '0');
		else
		    unput(ntok);
	    } else
		unput(ntok);
	    return ((int)bitp);
	} else
	    return (ntok);
    }
}

/* processes a block comment, /* through */ /**/
static void
comment()
{
    int c;

    c = input();
    for (;;) {
	switch (c)  {
	    case 0:
		FATAL("unterminated comment at EOF");
		return;
	    case '\n':
		lineno++;
		c = input();
		continue;
	    case '/':
		c = input();
		if (c == '*') {
		    comment();
		    c = input();
		}
		continue;
	    case '*':
		c = input();
		if (c == '/')
		    return;
		continue;
	    default:
		c = input();
		continue;
	}
    }
}
