/*  param.c -- parameter block handling  */

#include <stdio.h>
#include "sr.h"
#include "funcs.h"
#include "../srsys.h"

static void build_inv_desc(), par_size();



/*  allocate param block and fill in packet size; return size of static area  */

int
pb_alloc(formals, actuals, result, overhead, where, owner,block_size)
Symptr formals;			/* formal parameter list */
Nodeptr actuals;		/* actual parameter list */
Nodeptr result;			/* signature of result */
int  where,			/* offset to put the pb pointer in */
     overhead,			/* bytes of overhead in pb */
     owner,			/* owner of this block */
     block_size;		/* offset to put size in */
{
    int st_size;
    Symptr f;
    Nodeptr l, a;

    cprintf("LA(%d)=sr_gen_alloc(LO(%d)=",where,block_size);
    
    /* sum sizes of parameters */
    st_size = 0;
    for (f=formals, l=actuals; f && l; f = f->s_next, l = l->e_r) {
	while (f->s_kind != K_PARAM && f->s_kind != K_RESULT)
	    f = f->s_next;
	a = l->e_l;

	if (f->s_dessize > 0)
	    st_size += align(f->s_dessize);
	if (f->s_size != SIZE_UNK)
	    st_size += align(f->s_size);
	else {
	    cprintf("R(");
	    par_size(f,a);
	    cprintf(")+");
	}
    }
    
    /* add in size of result */
    if (f) {
	if (f->s_dessize > 0) {
	    st_size += align(f->s_dessize);
	}
	if (f->s_size != SIZE_UNK) {
	    st_size += align(f->s_size);
	} else {
	    cprintf("R(");
	    par_size(f,result);
	    cprintf(")+");
	}
    }
    
    cprintf("%d,%d)", st_size+overhead, owner);
    
    /* fill in packet size */
    cprintf(",\n((pach)LA(%d))->size=LO(%d)",where,block_size);

    return st_size;
}


/* output leading comma and comma-separated list of param assignments */
void
copy_list(formals, actuals, result, pb_add, st_size)
Symptr formals;
Nodeptr actuals;
Nodeptr result;
int pb_add,		/* offset of address of parameter block */
    st_size;		/* size of static area */
{
    Symptr f, ldf;
    Nodeptr l, a, lda;
    
    /* lda remembers the last dynamic actual parameter, and ldf its formal */
    lda = 0;
    ldf = 0;
    
    /* scan formal and actual lists in parallel */
    for (f=formals, l=actuals; f && l; f = f->s_next, l = l->e_r) {
	/* skip non-parameters in formal list */
	    while (f && f->s_kind != K_PARAM && f->s_kind != K_RESULT)
		f = f->s_next;
	assert(f);
	a = l->e_l;
	if (f->s_dessize)  {
	    build_inv_desc(f, a, pb_add, st_size, ldf, lda);
	    ldf = f;
	    lda = a;
	}

	/* assign actual to formal */
	if (f->s_restrict == R_VAL || f->s_restrict == R_VALRES) {
	    cprintf(",\n");
	    gen_assign(make_formal(f,pb_add), a);
	}
	
    }
    /* skip non-parameters in formal list */
	while (f && f->s_kind != K_PARAM && f->s_kind != K_RESULT)
	    f = f->s_next;
    /* build descriptor for result, if any, and if needed */
    if (f && f->s_dessize) {
	assert(f->s_kind == K_RESULT);
	build_inv_desc(f, result, pb_add, st_size, ldf, lda);
    }
}


/* build a tree representing a formal parameter */
Nodeptr
make_formal(sym,pb_add)
Symptr sym;	/* symbol table entry */
int pb_add;	/* local pointing to parameter block */
{
    union e_lu left;
    Nodeptr p;

    left.e_int = pb_add;
    p = make_node(TK_PBADDR,left,NULLNODE);
    left.e_sym = sym;
    return make_node(TK_FORMAL,left,p);
}


/* return the size of an object or list */
int
static_size(p)
Nodeptr p;
{
    int size = 0;
    
    if (!p) return 0;
    if (p->e_op == TK_LIST) {
	for (; p; p=p->e_r)
	    size += static_size(p->e_l);
    } else {
	size = get_size(p);
	assert(size != SIZE_UNK);
    }
    return size;
}



/* fill in invocation header */

void
inv_header(pb, func, call_send, arm_number,blsize)
int pb;
Nodeptr func;
Token call_send;
int arm_number;
{
    char *f;

    /* fill in argsize */
    cprintf(",\n((invb)LA(%d))->arg_size=LO(%d)-%d",
	pb, blsize, INVOCATION_HEADER_SIZE);
    
    /* capability */
    cprintf(",\nmemcpy(&((invb)(LA(%d)))->opc,%a,%d)",pb,func,OP_CAP_SIZE);

    /* call-send flag */
    switch (call_send) {
	case TK_CALL:     f = "CALL_IN";    break;
	case TK_SEND:     f = "SEND_IN";    break;
	case TK_CO_CALL:  f = "COCALL_IN";  break;
	case TK_CO_SEND:  f = "COSEND_IN";  break;
    }
    cprintf(",\n((invb)LA(%d))->type=%s",pb,f);
    
    /* fill in arm_number if necessary */
    if (call_send == TK_CO_CALL || call_send == TK_CO_SEND)
	cprintf(",\n((invb)LA(%d))->co.arm_num=%d",pb,arm_number);
}




static void
build_inv_desc(f, a, pb_add, st_size, ldf, lda)
Symptr f, ldf;
Nodeptr a, lda;
int pb_add, st_size;
{
    Nodeptr lb, ub, lb2, ub2;
    
    if (f->s_ranges && !f->s_ranges->r_dim2) {	/* if one dimensional array */

	lb = f->s_ranges->r_dim1->e_l;
	ub = f->s_ranges->r_dim1->e_r;
	assert (!(runtime(lb)&&runtime(ub)));

	cprintf(",\nI(LA(%d)+%d)=", pb_add, f->s_desoff + AD_LB1);
	if (runtime(lb))
	    if (f->s_type == T_CHAR)
		cprintf("%e-%l+1",ub,a);
	    else
		cprintf("%e-%n+1",ub,a);
	else
	    cprintf("%e",lb);

	cprintf(",\nI(LA(%d)+%d)=", pb_add, f->s_desoff + AD_UB1);
	if (runtime(ub))
	    if (f->s_type == T_CHAR)
		cprintf("%e+%l-1",lb,a);
	    else
		cprintf("%e+%n-1",lb,a);
	else
	    cprintf("%e",ub);
	
    } else if (f->s_ranges && f->s_ranges->r_dim2) {	/* two dimensional */
	lb = f->s_ranges->r_dim1->e_l;
	ub = f->s_ranges->r_dim1->e_r;
	lb2 = f->s_ranges->r_dim2->e_l;
	ub2 = f->s_ranges->r_dim2->e_r;
	if (runtime(lb) + runtime(ub) + runtime(lb2) + runtime(ub2) > 1) {
	    FATAL("2 or more arbitrary sizes");
	    return;
	}
	/* do lb */
	cprintf(",\nI(LA(%d)+%d)=", pb_add, f->s_desoff + AD_LB1);
	if (runtime(lb))
	    cprintf("%e+1-%n/(%e-%e+1)",ub,a,ub2,lb2);
	else
	    cprintf("%e",lb);
    
	/* do ub */
	cprintf(",\nI(LA(%d)+%d)=", pb_add, f->s_desoff + AD_UB1);
	if (runtime(ub))
	    cprintf("%e+%n/(%e-%e+1)-1",lb,a,ub2,lb2);
	else
	    cprintf("%e",ub);
	    
	/* do lb2 */
	cprintf(",\nI(LA(%d)+%d)=", pb_add, f->s_desoff + AD_LB2);
	if (runtime(lb2))
	    cprintf("%e+1-%n/(%e-%e+1)",ub2,a,ub,lb);
	else
	    cprintf("%e",lb2);

	/* do ub2 */
	cprintf(",\nI(LA(%d)+%d)=", pb_add, f->s_desoff + AD_UB2);
	if (runtime(ub2))
	    cprintf("%e+%n/(%e-%e+1)-1",lb2,a,ub,lb);
	else
	    cprintf("%e",ub2);
    }
    
    /* size */
    cprintf(",\nI(LA(%d)+%d)=", pb_add, f->s_desoff + AD_SIZE);
    par_size(f,a);
	
    /* offset is based on preceding offset */
    cprintf(",\nI(LA(%d)+%d)=", pb_add, f->s_desoff + AD_ADDR);
    if (!lda)  {
	cprintf("%d",st_size);	/* this was the first one */
    } else {
	cprintf("I(LA(%d)+%d)+R(",pb_add, ldf->s_desoff + AD_ADDR);
	par_size(ldf,lda);		/* else add rounded size of prev one */
	cprintf(")");
    }
    
    /* max length if this is a variable-sized string */
    if (f->s_type == T_STRING && f->s_size == SIZE_UNK) {
	cprintf(",\nI(LA(%d)+%d)=",pb_add,f->s_desoff+AD_MAXL);
	if (a->e_sig->s_type == T_STRING)
	    cprintf("%L",a);
	else
	    cprintf("%z",a);
    }
}



/* par_size(f,a) - gen the size needed for formal f to hold the value of a */
static void
par_size(f,a)
Symptr f;
Nodeptr a;
{
    if (f->s_size != SIZE_UNK)
	cprintf("%d",f->s_size);
    else if (f->s_type == T_STRING && a->e_sig->s_type == T_CHAR)
	cprintf("R(%z+%d)",a,STR_OVH);
    else if (f->s_type == T_CHAR && a->e_sig->s_type == T_STRING)
	cprintf("%l",a);
    else
	cprintf("%z",a);
}



Bool
runtime(e)
Nodeptr e;
{   char friendly[80];

    switch (e->e_op) {
    case TK_RUNTIMESIZE:
    case TK_ARB:
	return TRUE;
    case TK_NUMBER:
    case TK_CHRLIT:
    case TK_IDENTIFIER:
	return FALSE;
    case TK_PLUS:
    case TK_MINUS:
    case TK_STAR:
    case TK_DIV:
	return (Bool)(runtime(e->e_l) || runtime(e->e_r));
    default:
	 sprintf(friendly,
		"bad node type in runtime: %s", tokentos(e->e_op));
	boom(friendly);
	/* NOTREACHED */
    }
}
